/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.uniqueid;

import com.jfireframework.baseutil.StringUtil;
import com.jfireframework.baseutil.uniqueid.ByteTool;
import com.jfireframework.baseutil.uniqueid.Uid;
import java.lang.management.ManagementFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class SpringId
implements Uid {
    private static final int countMask = 65535;
    static byte[] pid = new byte[2];
    static SpringId instance = new SpringId();
    private final AtomicInteger count = new AtomicInteger(0);

    private SpringId() {
    }

    public static SpringId getInstance() {
        return instance;
    }

    @Override
    public byte[] generateBytes() {
        long now = System.currentTimeMillis();
        int duration = (int)((now - 1548989749033L) / 1000L);
        byte[] result = new byte[8];
        result[0] = (byte)(duration >>> 24 & 0xFF);
        result[1] = (byte)(duration >>> 16 & 0xFF);
        result[2] = (byte)(duration >>> 8 & 0xFF);
        result[3] = (byte)(duration & 0xFF);
        result[4] = pid[0];
        result[5] = pid[1];
        int incrementAndGet = this.count.incrementAndGet() & 0xFFFF;
        result[6] = (byte)(incrementAndGet >>> 8 & 0xFF);
        result[7] = (byte)(incrementAndGet & 0xFF);
        return result;
    }

    @Override
    public String generate() {
        return StringUtil.toHexString(this.generateBytes());
    }

    @Override
    public long generateLong() {
        byte[] result = this.generateBytes();
        long tmp = ((long)result[0] & 0xFFL) << 56;
        tmp |= ((long)result[1] & 0xFFL) << 48;
        tmp |= ((long)result[2] & 0xFFL) << 40;
        tmp |= ((long)result[3] & 0xFFL) << 32;
        tmp |= ((long)result[4] & 0xFFL) << 24;
        tmp |= ((long)result[5] & 0xFFL) << 16;
        tmp |= ((long)result[6] & 0xFFL) << 8;
        return tmp |= (long)result[7] & 0xFFL;
    }

    @Override
    public String generateDigits() {
        long tmp = this.generateLong();
        char[] value = new char[]{ByteTool.toDigit((int)(tmp >>> 58 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 52 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 46 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 40 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 34 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 28 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 22 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 16 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 10 & 0x3FL)), ByteTool.toDigit((int)(tmp >>> 4 & 0x3FL)), ByteTool.toDigit((int)(tmp & 0xFL))};
        return String.valueOf(value);
    }

    static {
        String _pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        int pid = Integer.valueOf(_pid);
        SpringId.pid[0] = (byte)(pid >>> 8);
        SpringId.pid[1] = (byte)pid;
    }
}

