/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.uniqueid;

import com.jfireframework.baseutil.StringUtil;
import com.jfireframework.baseutil.uniqueid.ByteTool;
import com.jfireframework.baseutil.uniqueid.Uid;
import java.lang.management.ManagementFactory;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;

public class AutumnId
implements Uid {
    private static final int pid;
    private static final byte[] internal;
    private static final AtomicInteger count;
    private static final int mask = 65535;
    private static volatile AutumnId INSTANCE;

    private AutumnId() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final AutumnId instance() {
        if (INSTANCE != null) {
            return INSTANCE;
        }
        AtomicInteger atomicInteger = count;
        synchronized (atomicInteger) {
            if (INSTANCE != null) {
                return INSTANCE;
            }
            INSTANCE = new AutumnId();
            return INSTANCE;
        }
    }

    @Override
    public byte[] generateBytes() {
        byte[] result = new byte[12];
        long time = System.currentTimeMillis() - 1548989749033L;
        result[0] = (byte)(time >>> 32);
        result[1] = (byte)(time >>> 24);
        result[2] = (byte)(time >>> 16);
        result[3] = (byte)(time >>> 8);
        result[4] = (byte)time;
        result[5] = internal[0];
        result[6] = internal[1];
        result[7] = internal[2];
        result[8] = internal[3];
        result[9] = internal[4];
        int tmp = count.incrementAndGet() & 0xFFFF;
        result[10] = (byte)(tmp >>> 8);
        result[11] = (byte)tmp;
        return result;
    }

    @Override
    public String generate() {
        return StringUtil.toHexString(this.generateBytes());
    }

    @Override
    public long generateLong() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String generateDigits() {
        byte[] result = this.generateBytes();
        long tmp = ((long)result[0] & 0xFFL) << 40;
        tmp |= ((long)result[1] & 0xFFL) << 32;
        tmp |= ((long)result[2] & 0xFFL) << 24;
        tmp |= ((long)result[3] & 0xFFL) << 16;
        tmp |= ((long)result[4] & 0xFFL) << 8;
        char[] digs = new char[16];
        digs[0] = ByteTool.toDigit((int)((tmp |= (long)result[5] & 0xFFL) >>> 42 & 0x3FL));
        digs[1] = ByteTool.toDigit((int)(tmp >>> 36 & 0x3FL));
        digs[2] = ByteTool.toDigit((int)(tmp >>> 30 & 0x3FL));
        digs[3] = ByteTool.toDigit((int)(tmp >>> 24 & 0x3FL));
        digs[4] = ByteTool.toDigit((int)(tmp >>> 18 & 0x3FL));
        digs[5] = ByteTool.toDigit((int)(tmp >>> 12 & 0x3FL));
        digs[6] = ByteTool.toDigit((int)(tmp >>> 6 & 0x3FL));
        digs[7] = ByteTool.toDigit((int)(tmp & 0x3FL));
        tmp = ((long)result[6] & 0xFFL) << 40;
        tmp |= ((long)result[7] & 0xFFL) << 32;
        tmp |= ((long)result[8] & 0xFFL) << 24;
        tmp |= ((long)result[9] & 0xFFL) << 16;
        tmp |= ((long)result[10] & 0xFFL) << 8;
        digs[8] = ByteTool.toDigit((int)((tmp |= (long)result[11] & 0xFFL) >>> 42 & 0x3FL));
        digs[9] = ByteTool.toDigit((int)(tmp >>> 36 & 0x3FL));
        digs[10] = ByteTool.toDigit((int)(tmp >>> 30 & 0x3FL));
        digs[11] = ByteTool.toDigit((int)(tmp >>> 24 & 0x3FL));
        digs[12] = ByteTool.toDigit((int)(tmp >>> 18 & 0x3FL));
        digs[13] = ByteTool.toDigit((int)(tmp >>> 12 & 0x3FL));
        digs[14] = ByteTool.toDigit((int)(tmp >>> 6 & 0x3FL));
        digs[15] = ByteTool.toDigit((int)(tmp & 0x3FL));
        return new String(digs);
    }

    static {
        int _maxHash;
        internal = new byte[5];
        count = new AtomicInteger(0);
        String _pid = ManagementFactory.getRuntimeMXBean().getName().split("@")[0];
        pid = Integer.valueOf(_pid);
        try {
            _maxHash = StringUtil.toHexString(NetworkInterface.getByInetAddress(InetAddress.getLocalHost()).getHardwareAddress()).hashCode();
        }
        catch (Exception e) {
            _maxHash = new Random().nextInt();
        }
        AutumnId.internal[0] = (byte)(pid >>> 8);
        AutumnId.internal[1] = (byte)pid;
        AutumnId.internal[2] = (byte)(_maxHash >>> 16);
        AutumnId.internal[3] = (byte)(_maxHash >>> 8);
        AutumnId.internal[4] = (byte)_maxHash;
    }
}

