/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.smc.model;

import com.jfireframework.baseutil.smc.SmcHelper;
import com.jfireframework.baseutil.smc.model.FieldModel;
import com.jfireframework.baseutil.smc.model.MethodModel;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ClassModel {
    private String packageName = "com.jfireframe.smc.output";
    private String className;
    private Map<String, FieldModel> fieldStore = new HashMap<String, FieldModel>();
    private Map<MethodModel.MethodModelKey, MethodModel> methodStore = new HashMap<MethodModel.MethodModelKey, MethodModel>();
    private Set<String> constructors = new HashSet<String>();
    private Set<Class<?>> imports = new HashSet();
    private Set<Class<?>> interfaces = new HashSet();
    private Set<String> classSimpleName = new HashSet<String>();
    private Class<?> parentClass;

    public ClassModel(String className) {
        this.className = className;
    }

    public ClassModel(String className, Class<?> parentClass, Class<?> ... interCc) {
        this.className = className;
        this.parentClass = parentClass;
        for (Class<?> each : interCc) {
            this.interfaces.add(each);
        }
    }

    private String buildClassDefinition() {
        StringBuilder cache = new StringBuilder();
        if (this.parentClass == null || this.parentClass == Object.class) {
            cache.append("public class ").append(this.className);
        } else {
            cache.append("public class ").append(this.className).append(" extends ").append(SmcHelper.getReferenceName(this.parentClass, this));
        }
        if (!this.interfaces.isEmpty()) {
            cache.append(" implements ");
            boolean hasComma = false;
            for (Class<?> each : this.interfaces) {
                cache.append(SmcHelper.getReferenceName(each, this)).append(',');
                hasComma = true;
            }
            if (hasComma) {
                cache.setLength(cache.length() - 1);
            }
        }
        cache.append(" \r\n{\r\n");
        return cache.toString();
    }

    public void addInterface(Class<?> intercc) {
        this.addImport(intercc);
        this.interfaces.add(intercc);
    }

    public boolean addImport(Class<?> type) {
        if (this.imports.contains(type)) {
            return true;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            while (type.isArray()) {
                type = type.getComponentType();
            }
            if (type.isPrimitive()) {
                return true;
            }
        }
        if (!this.classSimpleName.add(type.getSimpleName())) {
            return false;
        }
        this.imports.add(type);
        return true;
    }

    public void addConstructor(String initStr, Class<?> ... params) {
        StringBuilder cache = new StringBuilder();
        cache.append("public ").append(this.className);
        if (params.length == 0) {
            cache.append("()\r\n{");
        } else {
            cache.append("(");
            for (int i = 0; i < params.length; ++i) {
                cache.append(SmcHelper.getReferenceName(params[i], this)).append(" ");
                cache.append("$").append(i).append(",");
            }
            cache.setLength(cache.length() - 1);
            cache.append(")\r\n{");
        }
        cache.append(initStr).append("}\r\n");
        this.constructors.add(cache.toString());
    }

    public void putMethodModel(MethodModel methodModel) {
        this.methodStore.put(methodModel.generateKey(), methodModel);
    }

    public MethodModel getMethodModel(MethodModel.MethodModelKey key) {
        return this.methodStore.get(key);
    }

    public MethodModel removeMethodModel(MethodModel.MethodModelKey key) {
        return this.methodStore.remove(key);
    }

    public String fileName() {
        return this.className + ".java";
    }

    public String className() {
        return this.className;
    }

    public void addField(FieldModel ... models) {
        for (FieldModel each : models) {
            this.fieldStore.put(each.getName(), each);
            this.addImport(each.getType());
        }
    }

    public Collection<MethodModel.MethodModelKey> methods() {
        return this.methodStore.keySet();
    }

    public String toString() {
        StringBuilder cache = new StringBuilder();
        cache.append(this.buildClassDefinition());
        for (String string : this.constructors) {
            cache.append('\t').append(string);
        }
        for (FieldModel fieldModel : this.fieldStore.values()) {
            cache.append('\t').append(fieldModel.toString());
        }
        for (MethodModel methodModel : this.methodStore.values()) {
            cache.append('\t').append(methodModel.toString());
        }
        cache.append("}");
        String content = cache.toString();
        cache.setLength(0);
        cache.append("package ").append(this.packageName).append(';').append("\r\n");
        for (Class<?> each : this.imports) {
            cache.append("import ").append(this.getClassName(each)).append(";\r\n");
        }
        cache.append(content);
        return cache.toString();
    }

    private String getClassName(Class<?> type) {
        if (!type.isArray()) {
            return type.getName().replace('$', '.');
        }
        StringBuilder cache = new StringBuilder();
        while (type.isArray()) {
            cache.append("[]");
            type = type.getComponentType();
        }
        return type.getName().replace('$', '.') + cache.toString();
    }

    public String toStringWithLineNo() {
        String source = this.toString();
        String[] tmp = source.split("\r\n");
        StringBuilder cache = new StringBuilder(source.length());
        int no = 1;
        for (String each : tmp) {
            if (no < 10) {
                cache.append("/*   ").append(no).append(" */  ");
            } else if (no < 100) {
                cache.append("/*  ").append(no).append(" */  ");
            } else if (no < 1000) {
                cache.append("/* ").append(no).append(" */  ");
            } else {
                cache.append("/*").append(no).append(" */  ");
            }
            cache.append(each).append("\r\n");
            ++no;
        }
        return cache.toString();
    }

    public void setParentClass(Class<?> ckass) {
        this.parentClass = ckass;
    }
}

