/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.reflect.copy;

import com.jfireframework.baseutil.reflect.ReflectUtil;
import com.jfireframework.baseutil.reflect.copy.Copy;
import com.jfireframework.baseutil.reflect.copy.CopyFrom;
import com.jfireframework.baseutil.reflect.copy.CopyIgnore;
import com.jfireframework.baseutil.reflect.copy.CopyTo;
import com.jfireframework.baseutil.reflect.copy.PropertyCopyDescriptor;
import com.jfireframework.baseutil.reflect.copy.PropertyCopyDescriptorFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;

public class CopyInstance<S, D>
implements Copy<S, D> {
    private final Class<S> source;
    private final Class<D> des;
    private final PropertyCopyDescriptor<S, D>[] copyDescriptors;

    public CopyInstance(Class<S> sources, Class<D> des, PropertyCopyDescriptorFactory factory) {
        this.source = sources;
        this.des = des;
        Field[] desFields = this.getAllFields(des);
        Map<String, Field> sourceFields = this.generateSourceFields();
        ArrayList<PropertyCopyDescriptor<S, D>> list = new ArrayList<PropertyCopyDescriptor<S, D>>();
        for (Field toField : desFields) {
            Field fromField;
            CopyIgnore copyIgnore;
            if (Modifier.isFinal(toField.getModifiers()) || Modifier.isStatic(toField.getModifiers()) || toField.isAnnotationPresent(CopyIgnore.class) && ((copyIgnore = toField.getAnnotation(CopyIgnore.class)).from() == Object.class || copyIgnore.from() == sources)) continue;
            if (toField.isAnnotationPresent(CopyIgnore.List.class)) {
                CopyIgnore.List copyIgnoreList = toField.getAnnotation(CopyIgnore.List.class);
                boolean ignore = false;
                for (Annotation annotation : copyIgnoreList.value()) {
                    if (annotation.from() != Object.class && annotation.from() != sources) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
            }
            String sourceProperty = null;
            if (toField.isAnnotationPresent(CopyFrom.List.class)) {
                CopyFrom.List copyFroms = toField.getAnnotation(CopyFrom.List.class);
                for (Annotation annotation : copyFroms.value()) {
                    if (annotation.from() != sources) continue;
                    sourceProperty = annotation.name();
                    break;
                }
            } else if (toField.isAnnotationPresent(CopyFrom.class) && toField.getAnnotation(CopyFrom.class).from() == this.source) {
                sourceProperty = toField.getAnnotation(CopyFrom.class).name();
            }
            if (sourceProperty == null) {
                sourceProperty = toField.getName();
            }
            if ((fromField = sourceFields.get(sourceProperty)) == null) continue;
            PropertyCopyDescriptor<S, D> descriptor = factory.getInstance(this.source, des, fromField, toField);
            list.add(descriptor);
        }
        this.copyDescriptors = list.toArray(new PropertyCopyDescriptor[list.size()]);
    }

    private Map<String, Field> generateSourceFields() {
        Field[] fields = this.getAllFields(this.source);
        HashMap<String, Field> map = new HashMap<String, Field>();
        for (Field fromField : fields) {
            CopyIgnore copyIgnore;
            if (Modifier.isFinal(fromField.getModifiers()) || Modifier.isStatic(fromField.getModifiers()) || fromField.isAnnotationPresent(CopyIgnore.class) && ((copyIgnore = fromField.getAnnotation(CopyIgnore.class)).to() == Object.class || copyIgnore.to() == this.des)) continue;
            if (fromField.isAnnotationPresent(CopyIgnore.List.class)) {
                CopyIgnore.List copyIgnoreList = fromField.getAnnotation(CopyIgnore.List.class);
                boolean ignore = false;
                CopyIgnore[] copyIgnoreArray = copyIgnoreList.value();
                int n = copyIgnoreArray.length;
                for (int i = 0; i < n; ++i) {
                    CopyIgnore copyIgnore2 = copyIgnoreArray[i];
                    if (copyIgnore2.to() != Object.class && copyIgnore2.to() != this.source) continue;
                    ignore = true;
                    break;
                }
                if (ignore) continue;
            }
            if (fromField.isAnnotationPresent(CopyTo.List.class)) {
                CopyTo.List copyTos = fromField.getAnnotation(CopyTo.List.class);
                for (CopyTo copyTo : copyTos.value()) {
                    if (copyTo.to() != this.des) continue;
                    map.put(copyTo.name(), fromField);
                }
            }
            if (fromField.isAnnotationPresent(CopyTo.class) && fromField.getAnnotation(CopyTo.class).to() == this.des) {
                map.put(fromField.getAnnotation(CopyTo.class).name(), fromField);
            }
            map.put(fromField.getName(), fromField);
        }
        return map;
    }

    @Override
    public D copy(S src, D desc) {
        if (src == null || desc == null) {
            return desc;
        }
        try {
            for (PropertyCopyDescriptor<S, D> copyDescriptor : this.copyDescriptors) {
                copyDescriptor.process(src, desc);
            }
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
        return desc;
    }

    Field[] getAllFields(Class<?> entityClass) {
        TreeSet<Field> set = new TreeSet<Field>(new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                if (o1.getName().equals(o2.getName())) {
                    return 0;
                }
                return 1;
            }
        });
        while (entityClass != Object.class && entityClass != null) {
            for (Field each : entityClass.getDeclaredFields()) {
                set.add(each);
            }
            entityClass = entityClass.getSuperclass();
        }
        return set.toArray(new Field[set.size()]);
    }
}

