/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.reflect;

import com.jfireframework.baseutil.reflect.ParalLock;
import com.jfireframework.baseutil.reflect.ReflectUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;

public class SimpleHotswapClassLoader
extends URLClassLoader {
    private static final ParalLock PARAL_LOCK = new ParalLock();
    private final File reloadPathFile;
    private ClassLoader parent;
    private ConcurrentHashMap<String, Class<?>> classMap = new ConcurrentHashMap();
    private String[] reloadPackages = new String[0];
    private String[] reloadPackageForClassFiless = new String[0];
    private String[] excludePackages = new String[0];

    public SimpleHotswapClassLoader(String reloadPath) {
        super(new URL[0]);
        this.parent = this.getClass().getClassLoader();
        this.reloadPathFile = new File(reloadPath);
    }

    public void setReloadPackages(String ... reloadPackages) {
        this.reloadPackages = reloadPackages;
        this.reloadPackageForClassFiless = new String[reloadPackages.length];
        for (int i = 0; i < reloadPackages.length; ++i) {
            this.reloadPackageForClassFiless[i] = reloadPackages[i].replace(".", "/");
        }
    }

    public void setExcludePackages(String ... excludePackages) {
        this.excludePackages = excludePackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        if (this.classMap.containsKey(name)) {
            return this.classMap.get(name);
        }
        Object object = PARAL_LOCK.getLock(name);
        synchronized (object) {
            String[] stringArray = this.reloadPackages;
            int n = stringArray.length;
            int n2 = 0;
            while (true) {
                block22: {
                    int n3;
                    String[] stringArray2;
                    boolean canLoad;
                    block24: {
                        block23: {
                            if (n2 >= n) break block23;
                            String reloadPackage = stringArray[n2];
                            if (!name.startsWith(reloadPackage)) break block22;
                            canLoad = true;
                            stringArray2 = this.excludePackages;
                            n3 = stringArray2.length;
                            break block24;
                        }
                        Class<?> c = this.findLoadedClass(name);
                        if (c == null) {
                            try {
                                c = this.parent.loadClass(name);
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                // empty catch block
                            }
                            if (c == null) {
                                c = this.findClass(name);
                            }
                        }
                        this.classMap.put(name, c);
                        return c;
                    }
                    for (int i = 0; i < n3; ++i) {
                        String excludePackage = stringArray2[i];
                        if (!name.startsWith(excludePackage)) continue;
                        canLoad = false;
                        break;
                    }
                    if (canLoad) {
                        FileInputStream inputStream = null;
                        try {
                            File file = new File(this.reloadPathFile, name.replace(".", "/") + ".class");
                            inputStream = new FileInputStream(file);
                            byte[] src = new byte[inputStream.available()];
                            inputStream.read(src);
                            Class<?> c = this.defineClass(name, src, 0, src.length);
                            this.classMap.put(name, c);
                            Class<?> clazz = c;
                            return clazz;
                        }
                        catch (Exception e) {
                            ReflectUtil.throwException(e);
                        }
                        finally {
                            if (inputStream != null) {
                                try {
                                    inputStream.close();
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                }
                ++n2;
            }
        }
    }

    @Override
    public URL[] getURLs() {
        return ((URLClassLoader)this.parent).getURLs();
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.parent.getResources(name);
    }

    @Override
    public URL getResource(String name) {
        for (String reloadPackageForClass : this.reloadPackageForClassFiless) {
            if (!name.startsWith(reloadPackageForClass) || !name.endsWith(".class")) continue;
            File file = new File(this.reloadPathFile, name);
            try {
                return file.toURI().toURL();
            }
            catch (MalformedURLException e) {
                return this.parent.getResource(name);
            }
        }
        return this.parent.getResource(name);
    }
}

