/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.bytecode.structure.constantinfo;

import com.jfireframework.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfireframework.baseutil.bytecode.util.BinaryData;
import com.jfireframework.baseutil.bytecode.util.ConstantType;
import java.nio.charset.Charset;

public class Utf8Info
extends ConstantInfo {
    private static final Charset CHARSET = Charset.forName("utf8");
    private int length;
    private String value;

    public Utf8Info() {
        this.type = ConstantType.Utf8;
    }

    public int getLength() {
        return this.length;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return "Utf8Info{" + this.value + '}';
    }

    @Override
    public void resolve(BinaryData binaryData) {
        this.length = binaryData.readShort();
        byte[] content = new byte[this.length];
        binaryData.read(content);
        this.value = new String(content, CHARSET);
    }

    @Override
    public void resolve(ConstantInfo[] constant_pool) {
    }
}

