/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.bytecode.structure;

import com.jfireframework.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.ConstantInfo;
import com.jfireframework.baseutil.bytecode.structure.constantinfo.Utf8Info;
import com.jfireframework.baseutil.bytecode.util.BinaryData;
import java.util.Arrays;

public class MethodInfo {
    private int access_flags;
    private String name;
    private String descriptor;
    private AttributeInfo[] attributeInfos;

    public void resolve(BinaryData binaryData, ConstantInfo[] constantInfos) {
        this.access_flags = binaryData.readShort();
        int name_index = binaryData.readShort();
        this.name = ((Utf8Info)constantInfos[name_index - 1]).getValue();
        int descriptor_index = binaryData.readShort();
        this.descriptor = ((Utf8Info)constantInfos[descriptor_index - 1]).getValue();
        int attributes_count = binaryData.readShort();
        this.attributeInfos = new AttributeInfo[attributes_count];
        for (int i = 0; i < attributes_count; ++i) {
            this.attributeInfos[i] = AttributeInfo.parse(binaryData, constantInfos);
        }
    }

    public String toString() {
        return "MethodInfo{access_flags=" + this.access_flags + ", name='" + this.name + '\'' + ", descriptor='" + this.descriptor + '\'' + ", attributeInfos=" + Arrays.toString(this.attributeInfos) + '}';
    }

    public AttributeInfo[] getAttributeInfos() {
        return this.attributeInfos;
    }

    public String getName() {
        return this.name;
    }

    public String getDescriptor() {
        return this.descriptor;
    }
}

