/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil.bytecode.annotation;

import com.jfireframework.baseutil.bytecode.ClassFile;
import com.jfireframework.baseutil.bytecode.ClassFileParser;
import com.jfireframework.baseutil.bytecode.annotation.AbstractAnnotationMetadata;
import com.jfireframework.baseutil.bytecode.annotation.AnnotationMetadata;
import com.jfireframework.baseutil.bytecode.annotation.DefaultAnnotationMetadata;
import com.jfireframework.baseutil.bytecode.annotation.ValuePair;
import com.jfireframework.baseutil.bytecode.structure.AnnotationInfo;
import com.jfireframework.baseutil.bytecode.structure.Attribute.AttributeInfo;
import com.jfireframework.baseutil.bytecode.structure.Attribute.RuntimeVisibleAnnotationsAttriInfo;
import com.jfireframework.baseutil.bytecode.structure.MethodInfo;
import com.jfireframework.baseutil.bytecode.support.OverridesAttribute;
import com.jfireframework.baseutil.bytecode.util.BytecodeUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SupportOverrideAttributeAnnotationMetadata
extends AbstractAnnotationMetadata {
    static String name = OverridesAttribute.class.getName().replace('.', '/');
    private Map<String, List<OverrideItem>> map = new HashMap<String, List<OverrideItem>>();

    private SupportOverrideAttributeAnnotationMetadata(String resourceName, Map<String, ValuePair> attributes, ClassLoader loader) {
        super(resourceName, attributes, loader);
        byte[] bytecode = BytecodeUtil.loadBytecode(loader, resourceName);
        ClassFile classFile = new ClassFileParser(bytecode).parse();
        block0: for (MethodInfo methodInfo : classFile.getMethodInfos()) {
            for (AttributeInfo attributeInfo : methodInfo.getAttributeInfos()) {
                if (!(attributeInfo instanceof RuntimeVisibleAnnotationsAttriInfo)) continue;
                for (AnnotationInfo annotation : ((RuntimeVisibleAnnotationsAttriInfo)attributeInfo).getAnnotations()) {
                    if (!annotation.getType().equals(name)) continue;
                    AnnotationMetadata overrideAttribute = annotation.getAnnotation(loader);
                    ValuePair valuePair = overrideAttribute.getAttribyte("annotation");
                    String annotationResourceName = valuePair.getClassName().replace('.', '/');
                    String name = overrideAttribute.getAttribyte("name").getStringValue();
                    OverrideItem overrideItem = new OverrideItem();
                    overrideItem.overrideAnnotationName = annotationResourceName;
                    overrideItem.overrideAttribute = name;
                    overrideItem.attribute = methodInfo.getName();
                    overrideItem.valuePair = attributes.get(methodInfo.getName());
                    List<OverrideItem> overrideItems = this.map.get(annotationResourceName);
                    if (overrideItems == null) {
                        overrideItems = new LinkedList<OverrideItem>();
                        this.map.put(annotationResourceName, overrideItems);
                    }
                    overrideItems.add(overrideItem);
                    continue block0;
                }
                continue block0;
            }
        }
    }

    public static SupportOverrideAttributeAnnotationMetadata castFrom(DefaultAnnotationMetadata defaultAnnotationMetadata) {
        return new SupportOverrideAttributeAnnotationMetadata(defaultAnnotationMetadata.getResourceName(), defaultAnnotationMetadata.getAttributes(), defaultAnnotationMetadata.getLoader());
    }

    @Override
    public List<AnnotationMetadata> getPresentAnnotations() {
        if (this.presentAnnotations == null) {
            List<AnnotationMetadata> tmp = BytecodeUtil.findAnnotationsOnClass(this.type(), this.getClass().getClassLoader());
            this.presentAnnotations = new LinkedList();
            for (AnnotationMetadata annotationMetadata : tmp) {
                if (!(annotationMetadata instanceof DefaultAnnotationMetadata)) {
                    throw new UnsupportedOperationException();
                }
                SupportOverrideAttributeAnnotationMetadata castFrom = SupportOverrideAttributeAnnotationMetadata.castFrom((DefaultAnnotationMetadata)annotationMetadata);
                if (this.map.containsKey(castFrom.getResourceName())) {
                    List<OverrideItem> overrideItems = this.map.get(castFrom.getResourceName());
                    for (OverrideItem each : overrideItems) {
                        castFrom.attributes.put(each.overrideAttribute, each.valuePair);
                    }
                }
                this.presentAnnotations.add(castFrom);
            }
        }
        return this.presentAnnotations;
    }

    class OverrideItem {
        String overrideAnnotationName;
        String overrideAttribute;
        String attribute;
        ValuePair valuePair;

        OverrideItem() {
        }
    }
}

