/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil;

import com.jfireframework.baseutil.exception.UnSupportException;
import com.jfireframework.baseutil.reflect.ReflectUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Map;

public class StringUtil {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String toHexString(byte[] src) {
        char[] result = new char[src.length * 2];
        for (int i = 0; i < src.length; ++i) {
            result[i * 2] = DIGITS_LOWER[(src[i] & 0xF0) >>> 4];
            result[i * 2 + 1] = DIGITS_LOWER[src[i] & 0xF];
        }
        return new String(result);
    }

    public static String toHexString(byte[] src, int off, int length) {
        char[] result = new char[length * 2];
        length = off + length;
        for (int i = off; i < length; ++i) {
            result[i * 2] = DIGITS_LOWER[(src[i] & 0xF0) >>> 4];
            result[i * 2 + 1] = DIGITS_LOWER[src[i] & 0xF];
        }
        return new String(result);
    }

    public static byte[] hexStringToBytes(String hexStr) {
        return StringUtil.hexCharsToBytes(hexStr.toLowerCase().toCharArray());
    }

    public static byte[] hexCharsToBytes(char[] hexChars) {
        if ((hexChars.length & 1) == 1) {
            throw new UnSupportException("\u7528\u4e8e\u89e3\u6790\u7684\u5341\u516d\u8fdb\u5236\u5b57\u7b26\u6570\u7ec4\u7684\u957f\u5ea6\u4e0d\u5bf9\uff0c\u4e0d\u662f2\u7684\u6574\u6570\u500d");
        }
        int length = hexChars.length / 2;
        byte[] result = new byte[length];
        for (int i = 0; i < hexChars.length; i += 2) {
            int f = StringUtil.toDigit(hexChars[i]) << 4;
            result[i >> 1] = (byte)(f |= StringUtil.toDigit(hexChars[i + 1]));
        }
        return result;
    }

    private static int toDigit(char c) {
        for (int index = 0; index < 16; ++index) {
            if (DIGITS_LOWER[index] != c) continue;
            return index;
        }
        throw new UnSupportException("\u5b57\u7b26" + c + "\u4e0d\u662f\u5c0f\u5199\u5341\u516d\u8fdb\u5236\u7684\u5b57\u7b26");
    }

    public static boolean match(String src, String rule) {
        if (rule.contains("*")) {
            String[] tmps = rule.split("\\*");
            int index = 0;
            for (int i = 0; i < tmps.length && (index = src.indexOf(tmps[i], index)) >= 0; ++i) {
                index += tmps[i].length();
            }
            if (index == -1) {
                return false;
            }
            if (index == src.length() || index == 0) {
                return true;
            }
            return rule.charAt(rule.length() - 1) == '*';
        }
        return src.equals(rule);
    }

    public static boolean isNotBlank(String src) {
        return src != null && !src.equals("");
    }

    public static String format(String pattern, Object ... params) {
        StringBuilder cache = new StringBuilder();
        char[] value = pattern.toCharArray();
        int total = params.length;
        int start = 0;
        int pre = 0;
        for (int i = 0; i < total; ++i) {
            start = StringUtil.indexOfBrace(value, pre);
            if (start == -1) {
                cache.append(value, pre, value.length - pre);
                return cache.toString();
            }
            cache.append(value, pre, start - pre);
            cache.append(params[i]);
            pre = start + 2;
        }
        cache.append(value, pre, value.length - pre);
        return cache.toString();
    }

    public static String format(String messageTemplate, Map<String, String> values) {
        StringBuilder cache;
        block2: {
            int start;
            cache = new StringBuilder();
            cache.setLength(0);
            char[] charArray = messageTemplate.toCharArray();
            int end = 0;
            while ((start = StringUtil.indexOf('{', end, charArray)) != -1) {
                cache.append(charArray, end, start - end);
                end = StringUtil.indexOf('}', start, charArray);
                if (end != -1) {
                    String name = messageTemplate.substring(start + 1, end);
                    cache.append(values.get(name));
                    ++end;
                    continue;
                }
                cache.append(charArray, end, charArray.length - end);
                break block2;
            }
            cache.append(charArray, end, charArray.length - end);
        }
        return cache.toString();
    }

    private static int indexOf(char c, int index, char[] array) {
        for (int i = index; i < array.length; ++i) {
            if (array[i] != c) continue;
            return i;
        }
        return -1;
    }

    private static int indexOfBrace(char[] array, int off) {
        int length = array.length - 1;
        for (int i = off; i < length; ++i) {
            if (array[i] != '{' || array[i + 1] != '}') continue;
            return i;
        }
        return -1;
    }

    public static String getHexBytes(String str) {
        char[] array = str.toLowerCase().toCharArray();
        int length = array.length;
        byte[] tmp = new byte[length * 2];
        int index = 0;
        for (int i = 0; i < length; ++i) {
            char c = array[i];
            tmp[index++] = (byte)(c >>> 8);
            tmp[index++] = (byte)c;
        }
        return StringUtil.toHexString(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFromClasspath(String resName, Charset charset) {
        InputStream inputStream = null;
        try {
            inputStream = StringUtil.class.getClassLoader().getResourceAsStream(resName);
            byte[] src = new byte[inputStream.available()];
            inputStream.read(src);
            String string = new String(src, charset);
            return string;
        }
        catch (IOException e) {
            ReflectUtil.throwException(e);
            String string = null;
            return string;
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(StringUtil.getHexBytes("\u4f60\u597d"));
    }
}

