/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil;

import com.jfireframework.baseutil.StringUtil;
import com.jfireframework.baseutil.reflect.ReflectUtil;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class PackageScan {
    public static String[] scan(String packageName) {
        String filterNames = null;
        if (packageName.contains(":")) {
            filterNames = packageName.split(":")[1];
            packageName = packageName.split(":")[0];
        }
        LinkedList<String> classNames = new LinkedList<String>();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String resourceName = packageName.replaceAll("\\.", "/");
        try {
            Enumeration<URL> urls = loader.getResources(resourceName);
            while (urls.hasMoreElements()) {
                URL url = urls.nextElement();
                if (url.getProtocol().contains("file")) {
                    try {
                        File urlFile = new File(url.toURI());
                        packageName = packageName.substring(0, packageName.lastIndexOf(".") + 1);
                        PackageScan.findClassNamesByFile(packageName, urlFile, classNames);
                    }
                    catch (URISyntaxException e) {
                        ReflectUtil.throwException(e);
                    }
                    continue;
                }
                if (!url.getProtocol().contains("jar")) continue;
                PackageScan.getClassNamesByJar(url, resourceName, classNames);
            }
        }
        catch (IOException e1) {
            ReflectUtil.throwException(e1);
        }
        PackageScan.doFilter(filterNames, classNames);
        return classNames.toArray(new String[classNames.size()]);
    }

    private static void getClassNamesByJar(URL url, String packageName, List<String> classNames) {
        JarFile jarFile = null;
        try {
            JarURLConnection jarURLConnection = (JarURLConnection)url.openConnection();
            jarFile = jarURLConnection.getJarFile();
        }
        catch (IOException e) {
            throw new RuntimeException("url\u5730\u5740\uff1a'" + url.toString() + "'\u4e0d\u6b63\u786e", e);
        }
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String entryName = jarEntry.getName();
            if (!entryName.endsWith(".class") || !entryName.startsWith(packageName)) continue;
            String className = entryName.substring(0, entryName.indexOf(".class"));
            className = className.replaceAll("/", ".");
            classNames.add(className);
        }
    }

    private static void findClassNamesByFile(String packageName, File packageFile, List<String> classNames) {
        if (packageFile.isFile()) {
            String className = packageName + packageFile.getName().replace(".class", "");
            className = className.replaceAll("/", ".");
            classNames.add(className);
        } else {
            File[] files = packageFile.listFiles();
            String tmPackageName = packageName + packageFile.getName() + ".";
            for (File f : files) {
                PackageScan.findClassNamesByFile(tmPackageName, f, classNames);
            }
        }
    }

    private static void doFilter(String filterNames, List<String> classNames) {
        block4: {
            String[] filters;
            block3: {
                String[] filters2;
                if (filterNames == null) {
                    return;
                }
                if (!filterNames.startsWith("in~")) break block3;
                for (String filter : filters2 = filterNames.substring(3).split(",")) {
                    PackageScan.inFilter(filter, classNames);
                }
                break block4;
            }
            if (!filterNames.startsWith("out~")) break block4;
            for (String filter : filters = filterNames.substring(4).split(",")) {
                PackageScan.outFilter(filter, classNames);
            }
        }
    }

    private static void inFilter(String rule, List<String> classNames) {
        Iterator<String> iterator = classNames.iterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (StringUtil.match(value, rule)) continue;
            iterator.remove();
        }
    }

    private static void outFilter(String rule, List<String> classNames) {
        Iterator<String> iterator = classNames.iterator();
        while (iterator.hasNext()) {
            String value = iterator.next();
            if (!StringUtil.match(value, rule)) continue;
            iterator.remove();
        }
    }
}

