/*
 * Decompiled with CFR 0.152.
 */
package com.jfireframework.baseutil;

import com.jfireframework.baseutil.reflect.ReflectUtil;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IniReader {
    public static IniFile read(InputStream inputStream, Charset charset) {
        class Helper {
            Helper() {
            }

            int currentLine(byte[] src, int index) {
                for (int i = index; i < src.length; ++i) {
                    if (src[i] != 10) continue;
                    if (i > index && src[i - 1] == 13) {
                        return i - 1;
                    }
                    return i;
                }
                return src.length - 1;
            }
        }
        Helper helper = new Helper();
        SectionImpl preSection = null;
        IniFileImpl iniFileImpl = new IniFileImpl();
        try {
            int end;
            byte[] src = new byte[inputStream.available()];
            inputStream.read(src);
            int index = 0;
            while (index <= (end = helper.currentLine(src, index))) {
                if (end == index) {
                    ++index;
                    continue;
                }
                int skip = -1;
                skip = src[end] == 13 ? 2 : (src[end] == 10 ? 1 : 0);
                String value = skip > 0 ? new String(src, index, end - index, charset) : new String(src, index, end - index + 1, charset);
                char c = (value = value.trim()).charAt(0);
                if (c != ';' && c != '#') {
                    if (c == '[' && value.charAt(value.length() - 1) == ']') {
                        String sectionName = value.substring(1, value.length() - 1);
                        preSection = new SectionImpl(sectionName);
                        iniFileImpl.addSection(preSection);
                    } else {
                        int splitIndex = value.indexOf(61);
                        if (splitIndex > 0 && splitIndex < src.length) {
                            String k = value.substring(0, splitIndex).trim();
                            String v = value.substring(splitIndex + 1).trim();
                            iniFileImpl.putProperty(k, v);
                            if (preSection != null) {
                                preSection.putProperty(k, v);
                            }
                        }
                    }
                }
                index = end + skip;
                if (skip != 0) continue;
                break;
            }
            return iniFileImpl;
        }
        catch (Exception e) {
            ReflectUtil.throwException(e);
            return null;
        }
    }

    static class SectionImpl
    extends PropertyValueStoreImpl
    implements Section {
        final String name;
        protected Map<String, String[]> store = new HashMap<String, String[]>();

        public SectionImpl(String name) {
            this.name = name;
        }

        @Override
        public String name() {
            return this.name;
        }
    }

    static class IniFileImpl
    extends PropertyValueStoreImpl
    implements IniFile {
        Map<String, Section> sections = new HashMap<String, Section>();

        IniFileImpl() {
        }

        @Override
        public Section getSection(String name) {
            return this.sections.get(name);
        }

        void addSection(Section section) {
            this.sections.put(section.name(), section);
        }
    }

    static class PropertyValueStoreImpl
    implements PropertyValueStore {
        Map<String, String[]> store = new HashMap<String, String[]>();

        PropertyValueStoreImpl() {
        }

        @Override
        public String getValue(String property) {
            String[] result = this.store.get(property);
            if (result != null) {
                return result[0];
            }
            return null;
        }

        public void putProperty(String property, String value) {
            if (this.store.containsKey(property)) {
                String[] pred = this.store.get(property);
                String[] now = new String[pred.length + 1];
                System.arraycopy(pred, 0, now, 0, pred.length);
                now[pred.length] = value;
                this.store.put(property, now);
            } else {
                this.store.put(property, new String[]{value});
            }
        }

        @Override
        public Set<String> keySet() {
            return this.store.keySet();
        }

        @Override
        public String[] getValues(String property) {
            return this.store.get(property);
        }
    }

    public static interface IniFile
    extends PropertyValueStore {
        public Section getSection(String var1);
    }

    public static interface Section
    extends PropertyValueStore {
        public String name();
    }

    static interface PropertyValueStore {
        public String getValue(String var1);

        public String[] getValues(String var1);

        public Set<String> keySet();
    }
}

