/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.mods.stomp;

import com.jetdrone.vertx.mods.stomp.Frame;
import io.netty.buffer.ByteBuf;
import java.nio.charset.Charset;

public class StompDecoder {
    static final Charset UTF8 = Charset.forName("UTF-8");
    State state = State.EOF;

    public Frame receive(ByteBuf in) {
        Frame frame = null;
        while (in.isReadable()) {
            switch (this.state) {
                case HEADERS: {
                    ByteBuf linebuf = in.readBytes(in.bytesBefore((byte)10));
                    in.skipBytes(1);
                    if (linebuf.readableBytes() != 0) {
                        String line = linebuf.toString(UTF8);
                        if (frame == null) {
                            frame = new Frame(line);
                            break;
                        }
                        int idx = line.indexOf(":");
                        String key = line.substring(0, idx);
                        String value = line.substring(idx + 1);
                        key = key.replaceAll("^\\s+|\\s+$", "");
                        value = value.replaceAll("^\\s+|\\s+$", "");
                        frame.parseHeader(key, value);
                        break;
                    }
                    this.state = State.BODY;
                    break;
                }
                case BODY: {
                    String contentLength = frame.headers.get("content-length");
                    int read = -1;
                    if (contentLength != null) {
                        read = Integer.parseInt(contentLength);
                    }
                    ByteBuf body = read == -1 ? in.readBytes(in.bytesBefore((byte)0)) : in.readBytes(read);
                    in.skipBytes(1);
                    frame.body = body.toString(UTF8);
                    this.state = State.EOF;
                    break;
                }
                case EOF: {
                    if (in.getByte(in.readerIndex()) == 10) {
                        in.skipBytes(1);
                        break;
                    }
                    if (frame != null) {
                        return frame;
                    }
                    this.state = State.HEADERS;
                }
            }
        }
        return frame;
    }

    static enum State {
        HEADERS,
        BODY,
        EOF;

    }
}

