/*
 * Decompiled with CFR 0.152.
 */
package com.jetdrone.vertx.mods.stomp;

import com.jetdrone.vertx.mods.stomp.Frame;
import com.jetdrone.vertx.mods.stomp.StompClient;
import com.jetdrone.vertx.mods.stomp.StompFrameException;
import com.jetdrone.vertx.mods.stomp.StompSubscriptions;
import java.util.Random;
import java.util.UUID;
import org.vertx.java.busmods.BusModBase;
import org.vertx.java.core.Handler;
import org.vertx.java.core.eventbus.Message;
import org.vertx.java.core.json.JsonObject;

public class StompClientBusMod
extends BusModBase
implements Handler<Message<JsonObject>> {
    private static final Random RANDOM = new Random();
    private StompClient stompClient;
    private StompSubscriptions stompSubscriptions;
    private String baseAddress;

    private static String generateID() {
        return new UUID(RANDOM.nextLong(), RANDOM.nextLong()).toString();
    }

    private static String getRequiredField(String name, Message<JsonObject> msg) throws StompFrameException {
        String field = ((JsonObject)msg.body()).getString(name);
        if (field == null) {
            throw new StompFrameException("Field: <" + name + "> is required!");
        }
        return field;
    }

    public void start() {
        super.start();
        String host = this.getOptionalStringConfig("host", "localhost");
        int port = this.getOptionalIntConfig("port", 61613);
        String login = this.getOptionalStringConfig("login", null);
        String passcode = this.getOptionalStringConfig("passcode", null);
        this.stompSubscriptions = new StompSubscriptions();
        this.stompClient = new StompClient(this.vertx, this.logger, host, port, login, passcode, this.stompSubscriptions);
        this.stompClient.connect(null);
        this.baseAddress = this.getOptionalStringConfig("address", "vertx.mod-stomp-io");
        this.eb.registerHandler(this.baseAddress, (Handler)this);
    }

    public void stop() {
        this.stompClient.send(new Frame("DISCONNECT"), true, new Handler<Frame>(){

            public void handle(Frame event) {
            }
        });
    }

    public void handle(final Message<JsonObject> message) {
        String command = ((JsonObject)message.body()).getString("command");
        if (command == null) {
            this.sendError(message, "command must be specified");
            return;
        }
        final Frame frame = new Frame(command);
        try {
            switch (command) {
                case "connect": 
                case "disconnect": {
                    this.sendError(message, "This command is not allowed, CONNECT/DISCONNECT is handled by the module");
                    break;
                }
                case "send": {
                    boolean sync;
                    Object body;
                    frame.headers.put("destination", StompClientBusMod.getRequiredField("destination", message));
                    frame.headers.put("transaction", ((JsonObject)message.body()).getString("transaction"));
                    JsonObject headers = ((JsonObject)message.body()).getObject("headers");
                    if (headers != null) {
                        for (String header : headers.getFieldNames()) {
                            frame.headers.put(header, headers.getString(header));
                        }
                    }
                    if ((body = ((JsonObject)message.body()).getField("body")) != null) {
                        if (body instanceof String) {
                            frame.body = (String)body;
                            frame.headers.put("content-type", "text/plain");
                        } else if (body instanceof JsonObject) {
                            frame.body = ((JsonObject)body).encode();
                            frame.headers.put("content-type", "application/json");
                        }
                    }
                    if (sync = ((JsonObject)message.body()).getBoolean("sync", false)) {
                        frame.headers.put("receipt", StompClientBusMod.generateID());
                        this.stompClient.send(frame, false, new Handler<Frame>(){

                            public void handle(Frame frame) {
                                StompClientBusMod.this.sendOK(message, new JsonObject().putString("receipt", frame.headers.get("receipt-id")));
                            }
                        });
                        break;
                    }
                    this.stompClient.send(frame, true, new Handler<Frame>(){

                        public void handle(Frame event) {
                            StompClientBusMod.this.sendOK(message, null);
                        }
                    });
                    break;
                }
                case "subscribe": {
                    final String subscribeId = ((JsonObject)message.body()).getString("id", StompClientBusMod.generateID());
                    String destination = StompClientBusMod.getRequiredField("destination", message);
                    frame.headers.put("id", subscribeId);
                    frame.headers.put("destination", destination);
                    frame.headers.put("ack", ((JsonObject)message.body()).getString("ack", "auto"));
                    JsonObject headers = ((JsonObject)message.body()).getObject("headers");
                    if (headers != null) {
                        for (String header : headers.getFieldNames()) {
                            frame.headers.put(header, headers.getString(header));
                        }
                    }
                    final String vertxChannel = this.baseAddress + destination;
                    this.stompSubscriptions.registerSubscribeHandler(subscribeId, new Handler<Frame>(){

                        public void handle(Frame reply) {
                            JsonObject replyMessage = new JsonObject();
                            replyMessage.putString("status", "ok");
                            replyMessage.putObject("value", reply.toJSON());
                            StompClientBusMod.this.eb.send(vertxChannel, replyMessage);
                        }
                    });
                    this.stompClient.send(frame, true, new Handler<Frame>(){

                        public void handle(Frame event) {
                            StompClientBusMod.this.sendOK(message, new JsonObject().putString("id", subscribeId));
                        }
                    });
                    break;
                }
                case "unsubscribe": {
                    final String unsubscribeId = StompClientBusMod.getRequiredField("id", message);
                    frame.headers.put("id", unsubscribeId);
                    this.stompClient.send(frame, true, new Handler<Frame>(){

                        public void handle(Frame event) {
                            StompClientBusMod.this.stompSubscriptions.unregisterSubscribeHandler(unsubscribeId);
                            StompClientBusMod.this.sendOK(message);
                        }
                    });
                    break;
                }
                case "ack": 
                case "nack": {
                    frame.headers.put("id", StompClientBusMod.getRequiredField("id", message));
                    frame.headers.put("transaction", ((JsonObject)message.body()).getString("transaction"));
                    this.stompClient.send(frame, true, new Handler<Frame>(){

                        public void handle(Frame event) {
                            StompClientBusMod.this.sendOK(message, null);
                        }
                    });
                    break;
                }
                case "begin": {
                    frame.headers.put("transaction", ((JsonObject)message.body()).getString("transaction", StompClientBusMod.generateID()));
                    this.stompClient.send(frame, true, new Handler<Frame>(){

                        public void handle(Frame event) {
                            StompClientBusMod.this.sendOK(message, new JsonObject().putString("transaction", frame.headers.get("transaction")));
                        }
                    });
                    break;
                }
                case "commit": 
                case "abort": {
                    frame.headers.put("transaction", StompClientBusMod.getRequiredField("transaction", message));
                    this.stompClient.send(frame, true, new Handler<Frame>(){

                        public void handle(Frame event) {
                            StompClientBusMod.this.sendOK(message, null);
                        }
                    });
                    break;
                }
                default: {
                    this.sendError(message, "Invalid command: " + command);
                    break;
                }
            }
        }
        catch (StompFrameException ex) {
            ex.printStackTrace();
            this.sendError(message, ex.getMessage());
        }
    }
}

