/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.framework;

import com.jetbrains.rd.framework.AbstractBuffer;
import com.jetbrains.rd.framework.Protocol;
import com.jetbrains.rd.framework.RdId;
import com.jetbrains.rd.framework.base.IRdReactiveKt;
import com.jetbrains.rd.framework.base.IRdWireable;
import com.jetbrains.rd.util.CollectionExKt;
import com.jetbrains.rd.util.LogLevel;
import com.jetbrains.rd.util.Logger;
import com.jetbrains.rd.util.SwitchLogger;
import com.jetbrains.rd.util.Sync;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IScheduler;
import com.jetbrains.rd.util.string.IPrintable;
import com.jetbrains.rd.util.string.PrettyPrinter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 $2\u00020\u0001:\u0002$%B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0011J\u0016\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\n2\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0006\u0010\u001e\u001a\u00020\u0013J\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u00112\u0006\u0010 \u001a\u00020\nJ\u001e\u0010!\u001a\u00020\u0013*\u00020\u00112\u0006\u0010\"\u001a\u00020\u001a2\b\b\u0002\u0010#\u001a\u00020\u0005H\u0002R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0010\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00110\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u0011`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lcom/jetbrains/rd/framework/MessageBroker;", "Lcom/jetbrains/rd/util/string/IPrintable;", "defaultScheduler", "Lcom/jetbrains/rd/util/reactive/IScheduler;", "queueMessages", "", "(Lcom/jetbrains/rd/util/reactive/IScheduler;Z)V", "(Lcom/jetbrains/rd/util/reactive/IScheduler;)V", "broker", "Ljava/util/HashMap;", "Lcom/jetbrains/rd/framework/RdId;", "Lcom/jetbrains/rd/framework/MessageBroker$Mq;", "Lkotlin/collections/HashMap;", "isQueueingAllMessages", "lock", "", "subscriptions", "Lcom/jetbrains/rd/framework/base/IRdWireable;", "adviseOn", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "entity", "dispatch", "id", "buffer", "Lcom/jetbrains/rd/framework/AbstractBuffer;", "print", "printer", "Lcom/jetbrains/rd/util/string/PrettyPrinter;", "startDeliveringMessages", "tryGetById", "rdId", "invoke", "msg", "sync", "Companion", "Mq", "rd-framework"})
public final class MessageBroker
implements IPrintable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IScheduler defaultScheduler;
    @NotNull
    private final Object lock;
    @NotNull
    private final HashMap<RdId, IRdWireable> subscriptions;
    @NotNull
    private final HashMap<RdId, Mq> broker;
    private boolean isQueueingAllMessages;
    @NotNull
    private static final SwitchLogger log = Protocol.Companion.sublogger("MQ");

    public MessageBroker(@NotNull IScheduler defaultScheduler) {
        Intrinsics.checkNotNullParameter((Object)defaultScheduler, (String)"defaultScheduler");
        this.defaultScheduler = defaultScheduler;
        this.lock = new Object();
        this.subscriptions = new HashMap();
        this.broker = new HashMap();
    }

    public MessageBroker(@NotNull IScheduler defaultScheduler, boolean queueMessages) {
        Intrinsics.checkNotNullParameter((Object)defaultScheduler, (String)"defaultScheduler");
        this(defaultScheduler);
        this.isQueueingAllMessages = queueMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void startDeliveringMessages() {
        Sync sync2 = Sync.INSTANCE;
        Object obj$iv = this.lock;
        boolean $i$f$lock = false;
        Object object = obj$iv;
        synchronized (object) {
            boolean bl = false;
            if (!this.isQueueingAllMessages) {
                boolean $i$a$-require-MessageBroker$startDeliveringMessages$1$22 = false;
                String $i$a$-require-MessageBroker$startDeliveringMessages$1$22 = "Already delivering messages";
                throw new IllegalArgumentException($i$a$-require-MessageBroker$startDeliveringMessages$1$22.toString());
            }
            this.isQueueingAllMessages = false;
            Set<Map.Entry<RdId, Mq>> set2 = this.broker.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"broker.entries");
            List entries = CollectionsKt.toList((Iterable)set2);
            this.broker.clear();
            Iterable $this$forEach$iv = entries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry entry = (Map.Entry)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"(id, mq)");
                RdId id = (RdId)entry.getKey();
                Mq mq = (Mq)entry.getValue();
                boolean value$iv = mq.getCustomSchedulerMessages().isEmpty();
                boolean $i$f$assert = false;
                if (_Assertions.ENABLED && !value$iv) {
                    boolean bl3 = false;
                    String string = "Unexpected custom scheduler messages";
                    throw new AssertionError((Object)string);
                }
                Iterable $this$forEach$iv2 = mq.getDefaultSchedulerMessages();
                boolean $i$f$forEach2 = false;
                for (Object element$iv2 : $this$forEach$iv2) {
                    AbstractBuffer it = (AbstractBuffer)element$iv2;
                    boolean bl4 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                    this.dispatch(id, it);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    private final void invoke(IRdWireable $this$invoke, AbstractBuffer msg, boolean sync2) {
        if (sync2) {
            $this$invoke.getProtocol().getContexts().readMessageContextAndInvoke(msg, (Function0<Unit>)((Function0)new Function0<Unit>($this$invoke, msg){
                final /* synthetic */ IRdWireable $this_invoke;
                final /* synthetic */ AbstractBuffer $msg;
                {
                    this.$this_invoke = $receiver;
                    this.$msg = $msg;
                    super(0);
                }

                public final void invoke() {
                    this.$this_invoke.onWireReceived(this.$msg);
                }
            }));
        } else {
            $this$invoke.getWireScheduler().queue((Function0)new Function0<Unit>($this$invoke, this, msg){
                final /* synthetic */ IRdWireable $this_invoke;
                final /* synthetic */ MessageBroker this$0;
                final /* synthetic */ AbstractBuffer $msg;
                {
                    this.$this_invoke = $receiver;
                    this.this$0 = $receiver2;
                    this.$msg = $msg;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 * Enabled aggressive block sorting
                 * Enabled unnecessary exception pruning
                 * Enabled aggressive exception aggregation
                 */
                public final void invoke() {
                    void $this$log$iv$iv;
                    void $this$trace$iv;
                    IRdWireable iRdWireable;
                    Object object;
                    if (this.$this_invoke.isBound()) {
                        boolean bl;
                        void obj$iv;
                        Sync sync2 = Sync.INSTANCE;
                        object = MessageBroker.access$getLock$p(this.this$0);
                        MessageBroker messageBroker = this.this$0;
                        iRdWireable = this.$this_invoke;
                        boolean $i$f$lock = false;
                        void var6_8 = obj$iv;
                        synchronized (var6_8) {
                            boolean bl2 = false;
                            bl = MessageBroker.access$getSubscriptions$p(messageBroker).containsKey(iRdWireable.getRdid());
                        }
                        if (bl) {
                            this.$this_invoke.getProtocol().getContexts().readMessageContextAndInvoke(this.$msg, (Function0<Unit>)((Function0)new Function0<Unit>(this.$this_invoke, this.$msg){
                                final /* synthetic */ IRdWireable $this_invoke;
                                final /* synthetic */ AbstractBuffer $msg;
                                {
                                    this.$this_invoke = $receiver;
                                    this.$msg = $msg;
                                    super(0);
                                }

                                public final void invoke() {
                                    this.$this_invoke.onWireReceived(this.$msg);
                                }
                            }));
                            return;
                        }
                    }
                    Logger this_$iv = (Logger)MessageBroker.Companion.getLog();
                    object = this.$this_invoke;
                    boolean $i$f$trace = false;
                    iRdWireable = $this$trace$iv;
                    LogLevel level$iv$iv = LogLevel.Trace;
                    boolean $i$f$log = false;
                    if (!$this$log$iv$iv.isEnabled(level$iv$iv)) return;
                    LogLevel logLevel = level$iv$iv;
                    void var9_13 = $this$log$iv$iv;
                    boolean bl = false;
                    String string = "Handler for " + object + " dissapeared";
                    var9_13.log(logLevel, (Object)string, null);
                }
            });
        }
    }

    static /* synthetic */ void invoke$default(MessageBroker messageBroker, IRdWireable iRdWireable, AbstractBuffer abstractBuffer, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        messageBroker.invoke(iRdWireable, abstractBuffer, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final IRdWireable tryGetById(@NotNull RdId rdId) {
        IRdWireable iRdWireable;
        Intrinsics.checkNotNullParameter((Object)rdId, (String)"rdId");
        Sync sync2 = Sync.INSTANCE;
        Object obj$iv = this.lock;
        boolean $i$f$lock = false;
        Object object = obj$iv;
        synchronized (object) {
            boolean bl = false;
            iRdWireable = this.subscriptions.get(rdId);
        }
        return iRdWireable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void dispatch(@NotNull RdId id, @NotNull AbstractBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        if (!(!id.isNull())) {
            boolean $i$a$-require-MessageBroker$dispatch$22 = false;
            String $i$a$-require-MessageBroker$dispatch$22 = "id mustn't be null";
            throw new IllegalArgumentException($i$a$-require-MessageBroker$dispatch$22.toString());
        }
        Sync sync2 = Sync.INSTANCE;
        Object obj$iv = this.lock;
        boolean $i$f$lock = false;
        Object object = obj$iv;
        synchronized (object) {
            Object object2;
            boolean bl = false;
            IRdWireable s = this.subscriptions.get(id);
            if (s == null || this.isQueueingAllMessages) {
                Map $this$getOrCreate$iv = this.broker;
                boolean $i$f$getOrCreate = false;
                Object object3 = $this$getOrCreate$iv.get(id);
                if (object3 == null) {
                    RdId it = id;
                    boolean bl2 = false;
                    Mq it$iv = new Mq();
                    boolean bl3 = false;
                    $this$getOrCreate$iv.put(id, it$iv);
                    object3 = it$iv;
                }
                Mq currentIdBroker = (Mq)object3;
                currentIdBroker.getDefaultSchedulerMessages().add(buffer);
                if (this.isQueueingAllMessages) {
                    return;
                }
                this.defaultScheduler.queue((Function0)new Function0<Unit>(this, id, currentIdBroker){
                    final /* synthetic */ MessageBroker this$0;
                    final /* synthetic */ RdId $id;
                    final /* synthetic */ Mq $currentIdBroker;
                    {
                        this.this$0 = $receiver;
                        this.$id = $id;
                        this.$currentIdBroker = $currentIdBroker;
                        super(0);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * WARNING - void declaration
                     */
                    public final void invoke() {
                        Sync $this$trace$iv;
                        AbstractBuffer $i$a$-lock-MessageBroker$dispatch$2$1$message$22;
                        Object obj$iv;
                        IRdWireable subscription = (IRdWireable)MessageBroker.access$getSubscriptions$p(this.this$0).get(this.$id);
                        Sync sync2 = Sync.INSTANCE;
                        Object object = MessageBroker.access$getLock$p(this.this$0);
                        Mq mq = this.$currentIdBroker;
                        boolean $i$f$lock2 = false;
                        RdId rdId = obj$iv;
                        synchronized (rdId) {
                            boolean $i$a$-lock-MessageBroker$dispatch$2$1$message$22 = false;
                            $i$a$-lock-MessageBroker$dispatch$2$1$message$22 = !((Collection)mq.getDefaultSchedulerMessages()).isEmpty() ? mq.getDefaultSchedulerMessages().remove(0) : null;
                        }
                        AbstractBuffer message = $i$a$-lock-MessageBroker$dispatch$2$1$message$22;
                        if (subscription == null) {
                            void $this$log$iv$iv;
                            Logger this_$iv = (Logger)MessageBroker.Companion.getLog();
                            obj$iv = this.$id;
                            boolean $i$f$trace = false;
                            Sync $i$f$lock2 = $this$trace$iv;
                            LogLevel level$iv$iv = LogLevel.Trace;
                            boolean $i$f$log = false;
                            if ($this$log$iv$iv.isEnabled(level$iv$iv)) {
                                LogLevel logLevel = level$iv$iv;
                                void var22_18 = $this$log$iv$iv;
                                boolean bl = false;
                                String string = "No handler for id: " + obj$iv;
                                var22_18.log(logLevel, (Object)string, null);
                            }
                        } else if (message != null) {
                            MessageBroker.access$invoke(this.this$0, subscription, message, Intrinsics.areEqual((Object)subscription.getWireScheduler(), (Object)MessageBroker.access$getDefaultScheduler$p(this.this$0)));
                        }
                        $this$trace$iv = Sync.INSTANCE;
                        obj$iv = MessageBroker.access$getLock$p(this.this$0);
                        Mq mq2 = this.$currentIdBroker;
                        MessageBroker messageBroker = this.this$0;
                        rdId = this.$id;
                        boolean $i$f$lock3 = false;
                        Object object2 = obj$iv;
                        synchronized (object2) {
                            boolean bl = false;
                            if (mq2.getDefaultSchedulerMessages().isEmpty()) {
                                Object object3 = (Mq)MessageBroker.access$getBroker$p(messageBroker).remove(rdId);
                                if (object3 != null && (object3 = ((Mq)object3).getCustomSchedulerMessages()) != null) {
                                    Iterable $this$forEach$iv = (Iterable)object3;
                                    boolean $i$f$forEach = false;
                                    for (T element$iv : $this$forEach$iv) {
                                        AbstractBuffer it = (AbstractBuffer)element$iv;
                                        boolean bl2 = false;
                                        if (subscription != null) {
                                            IRdWireable iRdWireable;
                                            IRdWireable $this$invoke_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2 = iRdWireable;
                                            boolean bl3 = false;
                                            if (!(!Intrinsics.areEqual((Object)$this$invoke_u24lambda_u2d4_u24lambda_u2d3_u24lambda_u2d2.getWireScheduler(), (Object)MessageBroker.access$getDefaultScheduler$p(messageBroker)))) {
                                                String string = "Failed requirement.";
                                                throw new IllegalArgumentException(string.toString());
                                            }
                                            MessageBroker.invoke$default(messageBroker, subscription, it, false, 2, null);
                                        }
                                    }
                                }
                            }
                            Unit unit = Unit.INSTANCE;
                        }
                    }
                });
                object2 = Unit.INSTANCE;
            } else if (Intrinsics.areEqual((Object)s.getWireScheduler(), (Object)this.defaultScheduler) || s.getWireScheduler().getOutOfOrderExecution()) {
                MessageBroker.invoke$default(this, s, buffer, false, 2, null);
                object2 = Unit.INSTANCE;
            } else {
                Mq mq = this.broker.get(id);
                if (mq != null) {
                    object2 = mq.getCustomSchedulerMessages().add(buffer);
                } else {
                    MessageBroker.invoke$default(this, s, buffer, false, 2, null);
                    object2 = Unit.INSTANCE;
                }
            }
            Unit unit = object2;
        }
    }

    public final void adviseOn(@NotNull Lifetime lifetime, @NotNull IRdWireable entity) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(!entity.getRdid().isNull())) {
            boolean bl = false;
            String string = "id is null for entity: " + entity;
            throw new IllegalArgumentException(string.toString());
        }
        CollectionExKt.blockingPutUnique((Map)this.subscriptions, (Lifetime)lifetime, (Object)this.lock, (Object)entity.getRdid(), (Object)entity);
        IScheduler iScheduler = IRdReactiveKt.getWireSchedulerIfBound(entity);
        boolean bl = iScheduler != null ? iScheduler.getOutOfOrderExecution() : false;
        if (bl) {
            lifetime.executeIfAlive((Function0)new Function0<Unit>(this, entity){
                final /* synthetic */ MessageBroker this$0;
                final /* synthetic */ IRdWireable $entity;
                {
                    this.this$0 = $receiver;
                    this.$entity = $entity;
                    super(0);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * WARNING - void declaration
                 */
                public final void invoke() {
                    void obj$iv;
                    Sync sync2 = Sync.INSTANCE;
                    Object object = MessageBroker.access$getLock$p(this.this$0);
                    MessageBroker messageBroker = this.this$0;
                    IRdWireable iRdWireable = this.$entity;
                    boolean $i$f$lock = false;
                    void var6_6 = obj$iv;
                    synchronized (var6_6) {
                        Unit unit;
                        boolean bl = false;
                        Mq mq = (Mq)MessageBroker.access$getBroker$p(messageBroker).remove(iRdWireable.getRdid());
                        if (mq != null) {
                            Mq mq2 = mq;
                            boolean bl2 = false;
                            Iterable $this$forEach$iv = mq2.getDefaultSchedulerMessages();
                            boolean $i$f$forEach = false;
                            for (T element$iv : $this$forEach$iv) {
                                AbstractBuffer msg = (AbstractBuffer)element$iv;
                                boolean bl3 = false;
                                MessageBroker.invoke$default(messageBroker, iRdWireable, msg, false, 2, null);
                            }
                            mq2.getDefaultSchedulerMessages().clear();
                            boolean value$iv = mq2.getCustomSchedulerMessages().isEmpty();
                            boolean $i$f$assert = false;
                            if (_Assertions.ENABLED && !value$iv) {
                                boolean bl4 = false;
                                String string = "Custom scheduler messages for an entity with outOfOrder scheduler " + iRdWireable;
                                throw new AssertionError((Object)string);
                            }
                            unit = Unit.INSTANCE;
                        } else {
                            unit = null;
                        }
                        Unit unit2 = unit;
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(@NotNull PrettyPrinter printer) {
        Intrinsics.checkNotNullParameter((Object)printer, (String)"printer");
        Sync sync2 = Sync.INSTANCE;
        Object obj$iv = this.lock;
        boolean $i$f$lock = false;
        Object object = obj$iv;
        synchronized (object) {
            boolean bl = false;
            printer.println("MessageBroker Dump");
            printer.println();
            printer.println("Messages to unsubscribed: " + this.broker.size());
            if (this.broker.size() > 0) {
                printer.println();
                printer.println(StringsKt.padEnd$default((String)"Id", (int)20, (char)'\u0000', (int)2, null) + "    #Messages");
                printer.println(StringsKt.padStart((String)"", (int)20, (char)'-') + "----" + StringsKt.padStart((String)"", (int)9, (char)'-'));
                for (Map.Entry entry : ((Map)this.broker).entrySet()) {
                    String string;
                    RdId key = (RdId)entry.getKey();
                    Mq value2 = (Mq)entry.getValue();
                    int customSize = value2.getCustomSchedulerMessages().size();
                    PrettyPrinter prettyPrinter = printer;
                    StringBuilder stringBuilder = new StringBuilder().append(StringsKt.padEnd$default((String)String.valueOf(key), (int)20, (char)'\u0000', (int)2, null)).append(" -> ").append(value2.getDefaultSchedulerMessages().size());
                    boolean $this$condstr$iv = customSize > 0;
                    boolean $i$f$condstr = false;
                    if ($this$condstr$iv) {
                        StringBuilder stringBuilder2 = stringBuilder;
                        PrettyPrinter prettyPrinter2 = prettyPrinter;
                        boolean bl2 = false;
                        String string2 = " (+" + customSize + " background messages)";
                        prettyPrinter = prettyPrinter2;
                        stringBuilder = stringBuilder2;
                        string = string2;
                    } else {
                        string = "";
                    }
                    prettyPrinter.println(stringBuilder.append(string).toString());
                }
            }
            printer.println();
            printer.println("Subscribers:\n  ");
            Set<Map.Entry<RdId, IRdWireable>> set2 = this.subscriptions.entrySet();
            Intrinsics.checkNotNullExpressionValue(set2, (String)"subscriptions.entries");
            printer.println(CollectionsKt.joinToString$default((Iterable)set2, (CharSequence)"  ", null, null, (int)0, null, null, (int)62, null));
            Unit unit = Unit.INSTANCE;
        }
    }

    public static final /* synthetic */ Object access$getLock$p(MessageBroker $this) {
        return $this.lock;
    }

    public static final /* synthetic */ HashMap access$getSubscriptions$p(MessageBroker $this) {
        return $this.subscriptions;
    }

    public static final /* synthetic */ HashMap access$getBroker$p(MessageBroker $this) {
        return $this.broker;
    }

    public static final /* synthetic */ void access$invoke(MessageBroker $this, IRdWireable $receiver, AbstractBuffer msg, boolean sync2) {
        $this.invoke($receiver, msg, sync2);
    }

    public static final /* synthetic */ IScheduler access$getDefaultScheduler$p(MessageBroker $this) {
        return $this.defaultScheduler;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/rd/framework/MessageBroker$Companion;", "", "()V", "log", "Lcom/jetbrains/rd/util/SwitchLogger;", "getLog", "()Lcom/jetbrains/rd/util/SwitchLogger;", "rd-framework"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SwitchLogger getLog() {
            return log;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R!\u0010\u0003\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR*\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u00050\u0004j\b\u0012\u0004\u0012\u00020\u0005`\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\b\"\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/rd/framework/MessageBroker$Mq;", "", "()V", "customSchedulerMessages", "Ljava/util/ArrayList;", "Lcom/jetbrains/rd/framework/AbstractBuffer;", "Lkotlin/collections/ArrayList;", "getCustomSchedulerMessages", "()Ljava/util/ArrayList;", "defaultSchedulerMessages", "getDefaultSchedulerMessages", "setDefaultSchedulerMessages", "(Ljava/util/ArrayList;)V", "rd-framework"})
    private static final class Mq {
        @NotNull
        private ArrayList<AbstractBuffer> defaultSchedulerMessages = new ArrayList();
        @NotNull
        private final ArrayList<AbstractBuffer> customSchedulerMessages = new ArrayList();

        @NotNull
        public final ArrayList<AbstractBuffer> getDefaultSchedulerMessages() {
            return this.defaultSchedulerMessages;
        }

        public final void setDefaultSchedulerMessages(@NotNull ArrayList<AbstractBuffer> arrayList) {
            Intrinsics.checkNotNullParameter(arrayList, (String)"<set-?>");
            this.defaultSchedulerMessages = arrayList;
        }

        @NotNull
        public final ArrayList<AbstractBuffer> getCustomSchedulerMessages() {
            return this.customSchedulerMessages;
        }
    }
}

