/*
 * Decompiled with CFR 0.152.
 */
package com.jdroid.android.firebase.database;

import com.google.firebase.database.DataSnapshot;
import com.google.firebase.database.DatabaseError;
import com.google.firebase.database.ValueEventListener;
import com.jdroid.android.firebase.database.FirebaseDatabaseCountDownLatch;
import com.jdroid.android.firebase.database.FirebaseDatabaseException;
import com.jdroid.java.exception.UnexpectedException;

public class FirebaseDatabaseValueEventListener
implements ValueEventListener {
    private FirebaseDatabaseCountDownLatch done = new FirebaseDatabaseCountDownLatch();

    public void onDataChange(DataSnapshot snapshot) {
        this.done.setDataSnapshot(snapshot);
        this.done.countDown();
    }

    public void onCancelled(DatabaseError databaseError) {
        this.done.setFirebaseDatabaseException(new FirebaseDatabaseException(databaseError));
        this.done.countDown();
    }

    public void waitOperation() {
        try {
            this.done.await();
            if (this.done.getFirebaseDatabaseException() != null) {
                throw this.done.getFirebaseDatabaseException();
            }
        }
        catch (InterruptedException e) {
            throw new UnexpectedException((Throwable)e);
        }
    }

    public DataSnapshot getDataSnapshot() {
        return this.done.getDataSnapshot();
    }
}

