/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Issue;
import com.jcabi.github.Issues;
import com.jcabi.github.Repo;
import com.jcabi.github.Search;
import com.jcabi.github.mock.MkIssue;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.log.Logger;
import java.io.IOException;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkIssues
implements Issues {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkIssues(MkStorage stg, String login, Coordinates rep) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"issues"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public Issue get(int number) {
        return new MkIssue(this.storage, this.self, this.coords, number);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Issue create(String title, String body) throws IOException {
        int number;
        this.storage.lock();
        try {
            number = 1 + this.storage.xml().xpath(String.format("%s/issue/number/text()", this.xpath())).size();
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"issue").add((Object)"number").set((Object)Integer.toString(number)).up().add((Object)"state").set((Object)"open").up().add((Object)"title").set((Object)title).up().add((Object)"body").set((Object)body).up().add((Object)"created_at").set((Object)new Github.Time().toString()).up().add((Object)"updated_at").set((Object)new Github.Time().toString()).up().add((Object)"url").set((Object)"http://localhost/1").up().add((Object)"html_url").set((Object)"http://localhost/2").up().add((Object)"user").add((Object)"login").set((Object)this.self).up().up());
        }
        finally {
            this.storage.unlock();
        }
        Logger.info((Object)this, (String)"issue #%d created in %s by %s: %[text]s", (Object[])new Object[]{number, this.repo().coordinates(), this.self, title});
        return this.get(number);
    }

    @Override
    public Iterable<Issue> iterate(Map<String, String> params) {
        return new MkIterable<Issue>(this.storage, String.format("%s/issue", this.xpath()), xml -> this.get(Integer.parseInt((String)xml.xpath("number/text()").get(0))));
    }

    @Override
    public Iterable<Issue> search(Issues.Sort sort, Search.Order direction, EnumMap<Issues.Qualifier, String> qualifiers) {
        HashMap<String, String> params = new HashMap<String, String>();
        for (Map.Entry<Issues.Qualifier, String> entry : qualifiers.entrySet()) {
            params.put(entry.getKey().identifier(), entry.getValue());
        }
        params.put("sort", sort.identifier());
        params.put("direction", direction.identifier());
        return this.iterate(params);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/issues", this.coords);
    }

    public String toString() {
        return "MkIssues(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkIssues)) {
            return false;
        }
        MkIssues other = (MkIssues)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        return !(this$coords == null ? other$coords != null : !this$coords.equals(other$coords));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        return result;
    }
}

