/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Collaborators;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.User;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import java.io.IOException;
import org.apache.commons.lang3.NotImplementedException;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
final class MkCollaborators
implements Collaborators {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    public MkCollaborators(MkStorage stg, String login, Coordinates crds) throws IOException {
        this.storage = stg;
        this.self = login;
        this.coords = crds;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("/github/repos/repo[@coords='%s']", this.coords)).addIf((Object)"collaborators"));
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public boolean isCollaborator(String user) throws IOException {
        return !this.storage.xml().xpath(String.format("%s/user[login='%s']/text()", this.xpath(), user)).isEmpty();
    }

    @Override
    public void add(String user) throws IOException {
        this.storage.lock();
        try {
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"user").add((Object)"login").set((Object)user));
        }
        finally {
            this.storage.unlock();
        }
    }

    @Override
    public void remove(String user) throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("%s/user[login='%s']", this.xpath(), user)).remove());
    }

    @Override
    public Iterable<User> iterate() {
        return new MkIterable<User>(this.storage, String.format("%s/user", this.xpath()), xml -> new MkUser(this.storage, (String)xml.xpath("login/text()").get(0)));
    }

    @Override
    public void addWithPermission(String user, Collaborators.Permission permission) {
        throw new NotImplementedException("");
    }

    @Override
    public String permission(String user) {
        return "write";
    }

    public User get(String login) {
        return new MkUser(this.storage, login);
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/collaborators", this.coords);
    }
}

