/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comments;
import com.jcabi.github.Event;
import com.jcabi.github.Existence;
import com.jcabi.github.Github;
import com.jcabi.github.IssueLabels;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.Label;
import com.jcabi.github.Milestone;
import com.jcabi.github.Pull;
import com.jcabi.github.Reaction;
import com.jcabi.github.Repo;
import com.jcabi.github.SmartJson;
import com.jcabi.github.Smarts;
import com.jcabi.github.User;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;

@Immutable
public interface Issue
extends Comparable<Issue>,
JsonReadable,
JsonPatchable {
    public static final String OPEN_STATE = "open";
    public static final String CLOSED_STATE = "closed";

    public Repo repo();

    public int number();

    public Comments comments();

    public IssueLabels labels();

    public Iterable<Event> events() throws IOException;

    public boolean exists() throws IOException;

    public void react(Reaction var1) throws IOException;

    public Iterable<Reaction> reactions();

    public void lock(String var1);

    public void unlock();

    public boolean isLocked();

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Issue {
        private final transient Issue issue;
        private final transient SmartJson jsn;

        public Smart(Issue iss) {
            this.issue = iss;
            this.jsn = new SmartJson(iss);
        }

        public User author() throws IOException {
            return this.issue.repo().github().users().get(this.jsn.value("user", JsonObject.class).getString("login"));
        }

        public boolean isOpen() throws IOException {
            return Issue.OPEN_STATE.equals(this.state());
        }

        public void open() throws IOException {
            this.state(Issue.OPEN_STATE);
        }

        public void close() throws IOException {
            this.state(Issue.CLOSED_STATE);
        }

        public String state() throws IOException {
            return this.jsn.text("state");
        }

        public void state(String state) throws IOException {
            this.issue.patch(Json.createObjectBuilder().add("state", state).build());
        }

        public String title() throws IOException {
            return this.jsn.text("title");
        }

        public void title(String text) throws IOException {
            this.issue.patch(Json.createObjectBuilder().add("title", text).build());
        }

        public String body() throws IOException {
            return this.jsn.text("body");
        }

        public void body(String text) throws IOException {
            this.issue.patch(Json.createObjectBuilder().add("body", text).build());
        }

        public boolean hasBody() throws IOException {
            return this.jsn.hasNotNull("body");
        }

        public boolean hasAssignee() throws IOException {
            return this.jsn.hasNotNull("assignee");
        }

        public User assignee() throws IOException {
            if (!this.hasAssignee()) {
                throw new IllegalArgumentException(String.format("issue #%d doesn't have an assignee, use hasAssignee()", this.number()));
            }
            return this.issue.repo().github().users().get(this.jsn.value("assignee", JsonObject.class).getString("login"));
        }

        public void assign(String login) throws IOException {
            this.issue.patch(Json.createObjectBuilder().add("assignee", login).build());
        }

        public URL url() throws IOException {
            try {
                return new URI(this.jsn.text("url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public URL htmlUrl() throws IOException {
            try {
                return new URI(this.jsn.text("html_url")).toURL();
            }
            catch (URISyntaxException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        public Date createdAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Date closedAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("closed_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public Date updatedAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("updated_at")).date();
            }
            catch (ParseException ex) {
                throw new IllegalStateException(ex);
            }
        }

        public boolean isPull() throws IOException {
            return this.json().containsKey((Object)"pull_request") && !this.jsn.value("pull_request", JsonObject.class).isNull("html_url");
        }

        public Pull pull() throws IOException {
            String url = this.jsn.value("pull_request", JsonObject.class).getString("html_url");
            return this.issue.repo().pulls().get(Integer.parseInt(url.substring(url.lastIndexOf(47) + 1)));
        }

        public Event latestEvent(String type) throws IOException {
            Smarts events = new Smarts(this.issue.events());
            Event found = null;
            for (Event.Smart event : events) {
                if (!event.type().equals(type) || found != null && found.number() >= event.number()) continue;
                found = event;
            }
            if (found == null) {
                throw new IllegalStateException(String.format("event of type '%s' not found in issue #%d", type, this.issue.number()));
            }
            return found;
        }

        public IssueLabels roLabels() throws IOException {
            List array = this.jsn.value("labels", JsonArray.class).getValuesAs(JsonObject.class);
            final ArrayList<Label.Unmodified> labels = new ArrayList<Label.Unmodified>(array.size());
            for (JsonObject obj : array) {
                labels.add(new Label.Unmodified(this.repo(), obj.toString()));
            }
            return new IssueLabels(){

                @Override
                public Issue issue() {
                    return this;
                }

                @Override
                public void add(Iterable<String> labels2) {
                    throw new UnsupportedOperationException("The issue is read-only.");
                }

                @Override
                public void replace(Iterable<String> labels2) {
                    throw new UnsupportedOperationException("The issue is read-only.");
                }

                @Override
                public Iterable<Label> iterate() {
                    return labels;
                }

                @Override
                public void remove(String name) {
                    throw new UnsupportedOperationException("This issue is read-only.");
                }

                @Override
                public void clear() {
                    throw new UnsupportedOperationException("This issue is read-only.");
                }
            };
        }

        public boolean hasMilestone() throws IOException {
            return this.jsn.hasNotNull("milestone");
        }

        public Milestone milestone() throws IOException {
            return this.repo().milestones().get(this.jsn.value("milestone", JsonObject.class).getInt("number"));
        }

        public void milestone(Milestone milestone) throws IOException {
            this.patch(Json.createObjectBuilder().add("milestone", milestone.number()).build());
        }

        @Override
        public Repo repo() {
            return this.issue.repo();
        }

        @Override
        public int number() {
            return this.issue.number();
        }

        @Override
        public Comments comments() {
            return this.issue.comments();
        }

        @Override
        public IssueLabels labels() {
            return this.issue.labels();
        }

        @Override
        public Iterable<Event> events() throws IOException {
            return this.issue.events();
        }

        @Override
        public JsonObject json() throws IOException {
            return this.issue.json();
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.issue.patch(json);
        }

        @Override
        public int compareTo(Issue obj) {
            return this.issue.compareTo(obj);
        }

        @Override
        public boolean exists() throws IOException {
            return new Existence(this.issue).check();
        }

        @Override
        public void react(Reaction reaction) {
            throw new UnsupportedOperationException("react() not implemented");
        }

        public Collection<Reaction> reactions() {
            throw new UnsupportedOperationException("reactions() not implemented");
        }

        @Override
        public void lock(String reason) {
            throw new UnsupportedOperationException("lock not implemented");
        }

        @Override
        public void unlock() {
            throw new UnsupportedOperationException("unlock not implemented");
        }

        @Override
        public boolean isLocked() {
            throw new UnsupportedOperationException("isLocked not implemented");
        }

        public String toString() {
            return "Issue.Smart(issue=" + this.issue + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Issue this$issue = this.issue;
            Issue other$issue = other.issue;
            if (this$issue == null ? other$issue != null : !this$issue.equals(other$issue)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Issue $issue = this.issue;
            result = result * 59 + ($issue == null ? 43 : $issue.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

