/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Iterator;

@Loggable(value=1)
@Immutable
final class MkIterable<T>
implements Iterable<T> {
    private final transient MkStorage storage;
    private final transient String xpath;
    private final transient Mapping<T> mapping;

    MkIterable(MkStorage stg, String path, Mapping<T> map) {
        this.storage = stg;
        this.xpath = path;
        this.mapping = map;
    }

    @Override
    public Iterator<T> iterator() {
        Iterator nodes;
        try {
            nodes = this.storage.xml().nodes(this.xpath).iterator();
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return nodes.hasNext();
            }

            @Override
            public T next() {
                return MkIterable.this.mapping.map((XML)nodes.next());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("#remove()");
            }
        };
    }

    public String toString() {
        return "MkIterable(storage=" + this.storage + ", xpath=" + this.xpath + ", mapping=" + this.mapping + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkIterable)) {
            return false;
        }
        MkIterable other = (MkIterable)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$xpath = this.xpath;
        String other$xpath = other.xpath;
        if (this$xpath == null ? other$xpath != null : !this$xpath.equals(other$xpath)) {
            return false;
        }
        Mapping<T> this$mapping = this.mapping;
        Mapping<T> other$mapping = other.mapping;
        return !(this$mapping == null ? other$mapping != null : !this$mapping.equals(other$mapping));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $xpath = this.xpath;
        result = result * 59 + ($xpath == null ? 43 : $xpath.hashCode());
        Mapping<T> $mapping = this.mapping;
        result = result * 59 + ($mapping == null ? 43 : $mapping.hashCode());
        return result;
    }

    @Immutable
    public static interface Mapping<X> {
        public X map(XML var1);
    }
}

