/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Release;
import com.jcabi.github.Releases;
import com.jcabi.github.Repo;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtRelease;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtReleases
implements Releases {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    public RtReleases(Request req, Repo repo) {
        this.entry = req;
        this.owner = repo;
        this.request = this.entry.uri().path("/repos").path(repo.coordinates().user()).path(repo.coordinates().repo()).path("/releases").back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Iterable<Release> iterate() {
        return new RtPagination<Release>(this.request, object -> new RtRelease(this.entry, this.owner, object.getInt("id")));
    }

    @Override
    public Release get(int number) {
        return new RtRelease(this.entry, this.owner, number);
    }

    @Override
    public Release create(String tag) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("tag_name", tag).build();
        return this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getInt("id"));
    }

    @Override
    public void remove(int number) throws IOException {
        ((RestResponse)this.request.method("DELETE").uri().path(Integer.toString(number)).back().fetch().as(RestResponse.class)).assertStatus(204);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtReleases)) {
            return false;
        }
        RtReleases other = (RtReleases)o;
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

