/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.github.Check;
import com.jcabi.github.Checks;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Pull;
import com.jcabi.github.RtCheck;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import javax.json.JsonValue;

class RtChecks
implements Checks {
    private final transient Pull pull;
    private final transient Request request;

    RtChecks(Request req, Pull prequest) {
        this.pull = prequest;
        this.request = req;
    }

    @Override
    public Collection<? extends Check> all() throws IOException {
        Coordinates coords = this.pull.repo().coordinates();
        RestResponse rest = ((RestResponse)this.request.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/commits").path(this.pull.head().sha()).path("/check-runs").back().method("GET").fetch().as(RestResponse.class)).assertStatus(200);
        JsonObject object = ((JsonResponse)rest.as(JsonResponse.class)).json().readObject();
        return Optional.ofNullable(object.getJsonArray("check_runs")).map(obj -> obj.stream().map(RtChecks::check).collect(Collectors.toList())).orElseGet(Collections::emptyList);
    }

    private static RtCheck check(JsonValue value) {
        JsonObject check = value.asJsonObject();
        return new RtCheck(check.getString("status"), check.getString("conclusion"));
    }
}

