/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Gist;
import com.jcabi.github.Github;
import com.jcabi.github.JsonPatchable;
import com.jcabi.github.JsonReadable;
import com.jcabi.github.SmartJson;
import com.jcabi.github.User;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
public interface GistComment
extends Comparable<GistComment>,
JsonReadable,
JsonPatchable {
    public Gist gist();

    public int number();

    public void remove() throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements GistComment {
        private final transient GistComment comment;
        private final transient SmartJson jsn;

        public Smart(GistComment cmt) {
            this.comment = cmt;
            this.jsn = new SmartJson(cmt);
        }

        public User author() throws IOException {
            return this.comment.gist().github().users().get(this.comment.json().getJsonObject("user").getString("login"));
        }

        public String body() throws IOException {
            return this.jsn.text("body");
        }

        public void body(String text) throws IOException {
            this.comment.patch(Json.createObjectBuilder().add("body", text).build());
        }

        public URL url() throws IOException {
            return new URL(this.jsn.text("url"));
        }

        public Date createdAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("created_at")).date();
            }
            catch (ParseException ex) {
                throw new IOException(ex);
            }
        }

        public Date updatedAt() throws IOException {
            try {
                return new Github.Time(this.jsn.text("updated_at")).date();
            }
            catch (ParseException ex) {
                throw new IOException(ex);
            }
        }

        @Override
        public Gist gist() {
            return this.comment.gist();
        }

        @Override
        public int number() {
            return this.comment.number();
        }

        @Override
        public void remove() throws IOException {
            this.comment.remove();
        }

        @Override
        public int compareTo(GistComment cmt) {
            return this.comment.compareTo(cmt);
        }

        @Override
        public void patch(JsonObject json) throws IOException {
            this.comment.patch(json);
        }

        @Override
        public JsonObject json() throws IOException {
            return this.comment.json();
        }

        public String toString() {
            return "GistComment.Smart(comment=" + this.comment + ", jsn=" + this.jsn + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            GistComment this$comment = this.comment;
            GistComment other$comment = other.comment;
            if (this$comment == null ? other$comment != null : !this$comment.equals(other$comment)) {
                return false;
            }
            SmartJson this$jsn = this.jsn;
            SmartJson other$jsn = other.jsn;
            return !(this$jsn == null ? other$jsn != null : !((Object)this$jsn).equals(other$jsn));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            GistComment $comment = this.comment;
            result = result * 59 + ($comment == null ? 43 : $comment.hashCode());
            SmartJson $jsn = this.jsn;
            result = result * 59 + ($jsn == null ? 43 : ((Object)$jsn).hashCode());
            return result;
        }
    }
}

