/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.github.Check;
import java.util.Arrays;
import java.util.Locale;

class RtCheck
implements Check {
    private final transient Status status;
    private final transient Conclusion conclusion;

    RtCheck(String stat, String conc) {
        this(Status.fromString(stat), Conclusion.fromString(conc));
    }

    RtCheck(Status stat, Conclusion conc) {
        this.status = stat;
        this.conclusion = conc;
    }

    @Override
    public boolean successful() {
        return this.status.finished() && this.conclusion.successful();
    }

    static enum Conclusion {
        ACTION_REQUIRED("action_required"),
        CANCELLED("cancelled"),
        FAILURE("failure"),
        NEUTRAL("neutral"),
        SUCCESS("success"),
        SKIPPED("skipped"),
        STALE("stale"),
        TIMED_OUT("timed_out");

        private final String conclusion;

        private Conclusion(String con) {
            this.conclusion = con;
        }

        boolean successful() {
            return this == SUCCESS;
        }

        static Conclusion fromString(String value) {
            return Arrays.stream(Conclusion.values()).filter(stat -> stat.same(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid value %s for conclusion", value)));
        }

        boolean same(String value) {
            return this.conclusion.equals(value.toLowerCase(Locale.ROOT));
        }
    }

    static enum Status {
        QUEUED("queued"),
        IN_PROGRESS("in_progress"),
        COMPLETED("completed");

        private final String status;

        private Status(String stat) {
            this.status = stat;
        }

        boolean finished() {
            return this == COMPLETED;
        }

        static Status fromString(String value) {
            return Arrays.stream(Status.values()).filter(stat -> stat.same(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Invalid value %s for status", value)));
        }

        boolean same(String value) {
            return this.status.equals(value.toLowerCase(Locale.ROOT));
        }
    }
}

