/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Repo;
import com.jcabi.github.RtJson;
import com.jcabi.github.Tree;
import com.jcabi.http.Request;
import java.io.IOException;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtTree
implements Tree {
    private final transient Request request;
    private final transient Repo owner;
    private final transient String hash;

    RtTree(Request req, Repo repo, String sha) {
        Coordinates coords = repo.coordinates();
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/git").path("/trees").path(sha).back();
        this.owner = repo;
        this.hash = sha;
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public String sha() {
        return this.hash;
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtTree)) {
            return false;
        }
        RtTree other = (RtTree)o;
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        String this$hash = this.hash;
        String other$hash = other.hash;
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        String $hash = this.hash;
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }
}

