/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Content;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Issue;
import com.jcabi.github.Repo;
import com.jcabi.github.RtSearchPagination;
import com.jcabi.github.RtValuePagination;
import com.jcabi.github.Search;
import com.jcabi.github.User;
import com.jcabi.http.Request;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumMap;
import java.util.Map;
import java.util.regex.Pattern;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtSearch
implements Search {
    private static final Pattern SLASH = Pattern.compile("/");
    private static final Pattern QUERY = Pattern.compile("=");
    private final transient Github ghub;
    private final transient Request request;

    RtSearch(Github github, Request req) {
        this.ghub = github;
        this.request = req.uri().path("/search").back();
    }

    @Override
    public Github github() {
        return this.ghub;
    }

    @Override
    public Iterable<Repo> repos(String keywords, String sort, Search.Order order) {
        return new RtSearchPagination<Repo>(this.request, "repositories", keywords, sort, order.identifier(), new RtValuePagination.Mapping<Repo, JsonObject>(){

            @Override
            public Repo map(JsonObject object) {
                return RtSearch.this.github().repos().get(new Coordinates.Simple(object.getString("full_name")));
            }
        });
    }

    @Override
    public Iterable<Issue> issues(String keywords, String sort, Search.Order order, EnumMap<Search.Qualifier, String> qualifiers) {
        StringBuilder keyword = new StringBuilder(keywords);
        for (Map.Entry<Search.Qualifier, String> entry : qualifiers.entrySet()) {
            keyword.append('+').append(entry.getKey().identifier()).append(':').append(entry.getValue());
        }
        return new RtSearchPagination<Issue>(this.request, "issues", keyword.toString(), sort, order.identifier(), new RtValuePagination.Mapping<Issue, JsonObject>(){

            @Override
            public Issue map(JsonObject object) {
                try {
                    String[] parts = SLASH.split(new URI(object.getString("url")).getPath());
                    return RtSearch.this.ghub.repos().get(new Coordinates.Simple(parts[2], parts[3])).issues().get(object.getInt("number"));
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        });
    }

    @Override
    public Iterable<User> users(String keywords, String sort, Search.Order order) {
        return new RtSearchPagination<User>(this.request, "users", keywords, sort, order.identifier(), new RtValuePagination.Mapping<User, JsonObject>(){

            @Override
            public User map(JsonObject object) {
                return RtSearch.this.ghub.users().get(object.getString("login"));
            }
        });
    }

    @Override
    public Iterable<Content> codes(String keywords, String sort, Search.Order order) {
        return new RtSearchPagination<Content>(this.request, "code", keywords, sort, order.identifier(), new RtValuePagination.Mapping<Content, JsonObject>(){

            @Override
            public Content map(JsonObject object) {
                try {
                    URI uri = new URI(object.getString("url"));
                    String[] parts = SLASH.split(uri.getPath());
                    String ref = QUERY.split(uri.getQuery())[1];
                    return RtSearch.this.ghub.repos().get(new Coordinates.Simple(parts[2], parts[3])).contents().get(object.getString("path"), ref);
                }
                catch (URISyntaxException ex) {
                    throw new IllegalStateException(ex);
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtSearch)) {
            return false;
        }
        RtSearch other = (RtSearch)o;
        Github this$ghub = this.ghub;
        Github other$ghub = other.ghub;
        return !(this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Github $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        return result;
    }
}

