/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.Organization;
import com.jcabi.github.Organizations;
import com.jcabi.github.User;
import com.jcabi.github.UserOrganizations;
import com.jcabi.github.mock.MkGitHub;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkOrganizations;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import com.jcabi.xml.XML;
import java.io.IOException;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkUserOrganizations
implements UserOrganizations {
    private final transient MkStorage storage;
    private final transient String self;

    MkUserOrganizations(MkStorage stg, String login) throws IOException {
        this.storage = stg;
        this.self = login;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)"/github").addIf((Object)"orgs"));
    }

    @Override
    public GitHub github() {
        return new MkGitHub(this.storage, this.self);
    }

    @Override
    public User user() {
        return new MkUser(this.storage, this.self);
    }

    @Override
    public Iterable<Organization> iterate() throws IOException {
        return new MkIterable<Organization>(this.storage, "/github/orgs/org", new OrganizationMapping(new MkOrganizations(this.storage)));
    }

    @Generated
    public String toString() {
        return "MkUserOrganizations(storage=" + this.storage + ", self=" + this.self + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkUserOrganizations)) {
            return false;
        }
        MkUserOrganizations other = (MkUserOrganizations)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }

    private static final class OrganizationMapping
    implements MkIterable.Mapping<Organization> {
        private final transient Organizations orgs;

        OrganizationMapping(Organizations organizations) {
            this.orgs = organizations;
        }

        @Override
        public Organization map(XML xml) {
            return this.orgs.get((String)xml.xpath("login/text()").get(0));
        }
    }
}

