/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Assignees;
import com.jcabi.github.Branch;
import com.jcabi.github.Branches;
import com.jcabi.github.Collaborators;
import com.jcabi.github.Contents;
import com.jcabi.github.Coordinates;
import com.jcabi.github.DeployKeys;
import com.jcabi.github.Forks;
import com.jcabi.github.Git;
import com.jcabi.github.GitHub;
import com.jcabi.github.Hooks;
import com.jcabi.github.IssueEvents;
import com.jcabi.github.Issues;
import com.jcabi.github.Labels;
import com.jcabi.github.Language;
import com.jcabi.github.Milestones;
import com.jcabi.github.Notifications;
import com.jcabi.github.Pulls;
import com.jcabi.github.Releases;
import com.jcabi.github.Repo;
import com.jcabi.github.RepoCommits;
import com.jcabi.github.RtLanguage;
import com.jcabi.github.Stargazers;
import com.jcabi.github.Stars;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkAssignees;
import com.jcabi.github.mock.MkBranch;
import com.jcabi.github.mock.MkBranches;
import com.jcabi.github.mock.MkCollaborators;
import com.jcabi.github.mock.MkContents;
import com.jcabi.github.mock.MkDeployKeys;
import com.jcabi.github.mock.MkForks;
import com.jcabi.github.mock.MkGit;
import com.jcabi.github.mock.MkGitHub;
import com.jcabi.github.mock.MkHooks;
import com.jcabi.github.mock.MkIssueEvents;
import com.jcabi.github.mock.MkIssues;
import com.jcabi.github.mock.MkLabels;
import com.jcabi.github.mock.MkMilestones;
import com.jcabi.github.mock.MkNotifications;
import com.jcabi.github.mock.MkPulls;
import com.jcabi.github.mock.MkReleases;
import com.jcabi.github.mock.MkRepoCommits;
import com.jcabi.github.mock.MkStars;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.util.ArrayList;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class MkRepo
implements Repo {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkRepo(MkStorage stg, String login, Coordinates repo) {
        this.storage = stg;
        this.self = login;
        this.coords = repo;
    }

    @Override
    public GitHub github() {
        return new MkGitHub(this.storage, this.self);
    }

    @Override
    public Coordinates coordinates() {
        return this.coords;
    }

    @Override
    public Issues issues() {
        try {
            return new MkIssues(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Milestones milestones() {
        try {
            return new MkMilestones(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Pulls pulls() {
        try {
            return new MkPulls(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Hooks hooks() {
        try {
            return new MkHooks(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public IssueEvents issueEvents() {
        try {
            return new MkIssueEvents(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Labels labels() {
        try {
            return new MkLabels(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Assignees assignees() {
        return new MkAssignees(this.storage, this.self, this.coords);
    }

    @Override
    public Releases releases() {
        try {
            return new MkReleases(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Forks forks() {
        try {
            return new MkForks(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Collaborators collaborators() {
        try {
            return new MkCollaborators(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public DeployKeys keys() {
        try {
            return new MkDeployKeys(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Contents contents() {
        try {
            return new MkContents(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public RepoCommits commits() {
        try {
            return new MkRepoCommits(this.storage, this.self, this.coordinates());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Branches branches() {
        try {
            return new MkBranches(this.storage, this.self, this.coordinates());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Git git() {
        try {
            return new MkGit(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Stars stars() {
        try {
            return new MkStars(this.storage, this.self, this.coords);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Notifications notifications() {
        return new MkNotifications(this.storage, this.xpath().concat("/notifications/notification"));
    }

    @Override
    public Iterable<Language> languages() {
        ArrayList<Language> languages = new ArrayList<Language>(0);
        int java = 999;
        languages.add(new RtLanguage("Java", 999L));
        int php = 888;
        languages.add(new RtLanguage("PHP", 888L));
        int ruby = 777;
        languages.add(new RtLanguage("Ruby", 777L));
        return languages;
    }

    @Override
    public Branch defaultBranch() {
        return new MkBranch(this.storage, this.self, this.coords, "master", "");
    }

    @Override
    public Stargazers stargazers() {
        throw new UnsupportedOperationException(String.format("%s.stargazers() not yet implemented", this.getClass().getSimpleName()));
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public int compareTo(Repo repo) {
        return this.coords.compareTo(repo.coordinates());
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkRepo other = (MkRepo)obj;
            result = this.storage.equals(other.storage) && this.self.equals(other.self) && this.coords.equals(other.coords);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.self.hashCode();
        result = 31 * result + this.coords.hashCode();
        return result;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']", this.coords);
    }

    @Generated
    public String toString() {
        return "MkRepo(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }
}

