/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.GitHub;
import com.jcabi.github.Organization;
import com.jcabi.github.PublicMembers;
import com.jcabi.github.User;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkGitHub;
import com.jcabi.github.mock.MkPublicMembers;
import com.jcabi.github.mock.MkStorage;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Random;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
public final class MkOrganization
implements Organization {
    private static final Random RAND = new SecureRandom();
    private static final String LOGIN_KEY = "login";
    private final transient MkStorage storage;
    private final transient String self;

    public MkOrganization(MkStorage stg, String login) {
        this.storage = stg;
        this.self = login;
    }

    @Override
    public GitHub github() {
        return new MkGitHub(this.storage, this.self);
    }

    @Override
    public String login() {
        return this.self;
    }

    @Override
    public JsonObject json() {
        return Json.createObjectBuilder().add(LOGIN_KEY, this.self).add("id", Integer.toString(RAND.nextInt())).add("name", "github").add("company", "GitHub").add("blog", "https://github.com/blog").add("location", "San Francisco").add("email", "octocat@github.com").add("public_repos", RAND.nextInt()).add("public_gists", RAND.nextInt()).add("total_private_repos", RAND.nextInt()).add("owned_private_repos", RAND.nextInt()).add("followers", RAND.nextInt()).add("following", RAND.nextInt()).add("url", "https://github.com/orgs/cat").add("repos_url", "https://github.com/orgs/cat/repos").add("events_url", "https://github.com/orgs/cat/events").add("html_url", "https://github.com/cat").add("created_at", new GitHub.Time().toString()).add("type", "Organization").build();
    }

    @Override
    public int compareTo(Organization obj) {
        return this.login().compareTo(obj.login());
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public PublicMembers publicMembers() {
        return new MkPublicMembers(this.storage, this);
    }

    public void addMember(User user) {
        try {
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath().concat("/members")).add((Object)"member").add((Object)LOGIN_KEY).set((Object)user.login()).up().add((Object)"public").set((Object)"false").up());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String xpath() {
        return String.format("/github/orgs/org[login='%s']", this.self);
    }

    @Generated
    public String toString() {
        return "MkOrganization(storage=" + this.storage + ", self=" + this.self + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkOrganization)) {
            return false;
        }
        MkOrganization other = (MkOrganization)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

