/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.DeployKey;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkDeployKey
implements DeployKey {
    private final transient MkStorage storage;
    private final transient Repo owner;
    private final transient int key;

    MkDeployKey(MkStorage stg, int number, Repo repo) {
        this.storage = stg;
        this.key = number;
        this.owner = repo;
    }

    @Override
    public int number() {
        return this.key;
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void remove() throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).strict(1).remove());
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    public boolean equals(Object obj) {
        boolean result;
        if (this == obj) {
            result = true;
        } else if (obj == null || this.getClass() != obj.getClass()) {
            result = false;
        } else {
            MkDeployKey other = (MkDeployKey)obj;
            result = this.key == other.key && this.storage.equals(other.storage) && this.owner.equals(other.owner);
        }
        return result;
    }

    public int hashCode() {
        int result = this.storage.hashCode();
        result = 31 * result + this.owner.hashCode();
        result = 31 * result + this.key;
        return result;
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/deploykeys/deploykey[id='%d']", this.owner.coordinates(), this.key);
    }

    @Generated
    public String toString() {
        return "MkDeployKey(storage=" + this.storage + ", owner=" + this.owner + ", key=" + this.key + ")";
    }
}

