/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.github.Assignees;
import com.jcabi.github.Coordinates;
import com.jcabi.github.User;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;

@Immutable
final class MkAssignees
implements Assignees {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkAssignees(MkStorage stg, String login, Coordinates rep) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
    }

    @Override
    public Iterable<User> iterate() {
        HashSet<User> assignees = new HashSet<User>();
        assignees.add(new MkUser(this.storage, this.self));
        MkIterable<User> collabs = new MkIterable<User>(this.storage, this.xpath().concat("/user"), xml -> new MkUser(this.storage, (String)xml.xpath("login/text()").get(0)));
        for (User collab : collabs) {
            assignees.add(collab);
        }
        return assignees;
    }

    @Override
    public boolean check(String login) {
        try {
            List xpath = this.storage.xml().xpath(this.xpath().concat("/user/login/text()"));
            return this.self.equalsIgnoreCase(login) || !xpath.isEmpty() && login.equalsIgnoreCase((String)xpath.get(0));
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/collaborators", this.coords);
    }
}

