/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.xml.XML;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import org.w3c.dom.Node;

final class JsonNode {
    private final transient XML xml;

    JsonNode(XML src) {
        this.xml = src;
    }

    public JsonObject json() {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (XML child : this.xml.nodes("* ")) {
            Node node = child.inner();
            if (child.nodes("*").isEmpty()) {
                builder.add(node.getNodeName(), node.getTextContent());
                continue;
            }
            if (!child.xpath("//@array").isEmpty() && "true".equals(child.xpath("//@array").get(0))) {
                JsonArrayBuilder bld = Json.createArrayBuilder();
                for (XML item : child.nodes("*")) {
                    bld.add(item.inner().getTextContent());
                }
                builder.add(node.getNodeName(), (JsonValue)bld.build());
                continue;
            }
            builder.add(node.getNodeName(), (JsonValue)new JsonNode(child).json());
        }
        return builder.build();
    }
}

