/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Release;
import com.jcabi.github.ReleaseAssets;
import com.jcabi.github.Repo;
import com.jcabi.github.RtJson;
import com.jcabi.github.RtReleaseAssets;
import com.jcabi.http.Request;
import com.jcabi.http.response.RestResponse;
import jakarta.json.JsonObject;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtRelease
implements Release {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;
    private final transient int release;

    RtRelease(Request req, Repo repo, int nmbr) {
        this.entry = req;
        this.release = nmbr;
        this.owner = repo;
        this.request = req.uri().path("/repos").path(repo.coordinates().user()).path(repo.coordinates().repo()).path("/releases").path(String.valueOf(this.release)).back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public int number() {
        return this.release;
    }

    @Override
    public ReleaseAssets assets() {
        return new RtReleaseAssets(this.entry, this);
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new RtJson(this.request).patch(json);
    }

    @Override
    public void delete() throws IOException {
        ((RestResponse)this.request.method("DELETE").fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtRelease)) {
            return false;
        }
        RtRelease other = (RtRelease)o;
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

