/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.PublicKey;
import com.jcabi.github.PublicKeys;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtPublicKey;
import com.jcabi.github.User;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import jakarta.json.Json;
import jakarta.json.JsonStructure;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtPublicKeys
implements PublicKeys {
    private final transient Request entry;
    private final transient Request request;
    private final transient User owner;

    RtPublicKeys(Request req, User user) {
        this.entry = req;
        this.owner = user;
        this.request = this.entry.uri().path("/user").path("/keys").back();
    }

    @Override
    public User user() {
        return this.owner;
    }

    @Override
    public Iterable<PublicKey> iterate() {
        return new RtPagination<PublicKey>(this.request, object -> this.get(object.getInt("id")));
    }

    @Override
    public PublicKey create(String title, String key) throws IOException {
        return this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)Json.createObjectBuilder().add("title", title).add("key", key).build()).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getInt("id"));
    }

    @Override
    public PublicKey get(int number) {
        return new RtPublicKey(this.entry, this.owner, number);
    }

    @Override
    public void remove(int number) throws IOException {
        ((RestResponse)this.request.method("DELETE").uri().path(Integer.toString(number)).back().fetch().as(RestResponse.class)).assertStatus(204);
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtPublicKeys)) {
            return false;
        }
        RtPublicKeys other = (RtPublicKeys)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        User this$owner = this.owner;
        User other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        User $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

