/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.DeployKey;
import com.jcabi.github.DeployKeys;
import com.jcabi.github.Repo;
import com.jcabi.github.RtDeployKey;
import com.jcabi.github.RtPagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import jakarta.json.Json;
import jakarta.json.JsonStructure;
import java.io.IOException;
import lombok.Generated;

@Immutable
@Loggable(value=1)
final class RtDeployKeys
implements DeployKeys {
    private final transient Repo owner;
    private final transient Request entry;
    private final transient Request request;

    RtDeployKeys(Request req, Repo repo) {
        this.owner = repo;
        this.entry = req;
        this.request = req.uri().path("/repos").path(repo.coordinates().user()).path(repo.coordinates().repo()).path("/keys").back();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Iterable<DeployKey> iterate() {
        return new RtPagination<DeployKey>(this.request, object -> this.get(object.getInt("id")));
    }

    @Override
    public DeployKey get(int number) {
        return new RtDeployKey(this.entry, number, this.owner);
    }

    @Override
    public DeployKey create(String title, String key) throws IOException {
        return this.get(((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)Json.createObjectBuilder().add("title", title).add("key", key).build()).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json().readObject().getInt("id"));
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtDeployKeys)) {
            return false;
        }
        RtDeployKeys other = (RtDeployKeys)o;
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

