/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Label;
import com.jcabi.github.Repo;
import java.io.IOException;
import lombok.Generated;

@Immutable
public interface Labels {
    public Repo repo();

    public Label create(String var1, String var2) throws IOException;

    public Label get(String var1);

    public Iterable<Label> iterate();

    public void delete(String var1) throws IOException;

    @Immutable
    @Loggable(value=1)
    public static final class Smart
    implements Labels {
        private final transient Labels labels;

        public Smart(Labels lbl) {
            this.labels = lbl;
        }

        public boolean contains(String name) {
            boolean contains = false;
            for (Label label : this.labels.iterate()) {
                if (!label.name().equals(name)) continue;
                contains = true;
                break;
            }
            return contains;
        }

        public Label createOrGet(String name) throws IOException {
            return this.createOrGet(name, "c0c0c0");
        }

        public Label createOrGet(String name, String color) throws IOException {
            Label.Smart label;
            if (this.contains(name)) {
                label = new Label.Smart(this.labels.get(name));
                if (!label.color().equals(color)) {
                    label.color(color);
                }
            } else {
                label = new Label.Smart(this.labels.create(name, color));
            }
            return label;
        }

        @Override
        public Repo repo() {
            return this.labels.repo();
        }

        @Override
        public Label create(String name, String color) throws IOException {
            return this.labels.create(name, color);
        }

        @Override
        public Label get(String name) {
            return this.labels.get(name);
        }

        @Override
        public Iterable<Label> iterate() {
            return this.labels.iterate();
        }

        @Override
        public void delete(String name) throws IOException {
            this.labels.delete(name);
        }

        @Generated
        public String toString() {
            return "Labels.Smart(labels=" + this.labels + ")";
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Smart)) {
                return false;
            }
            Smart other = (Smart)o;
            Labels this$labels = this.labels;
            Labels other$labels = other.labels;
            return !(this$labels == null ? other$labels != null : !this$labels.equals(other$labels));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Labels $labels = this.labels;
            result = result * 59 + ($labels == null ? 43 : $labels.hashCode());
            return result;
        }
    }
}

