/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.Notifications;
import com.jcabi.github.PublicKeys;
import com.jcabi.github.User;
import com.jcabi.github.UserEmails;
import com.jcabi.github.UserOrganizations;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkGithub;
import com.jcabi.github.mock.MkNotifications;
import com.jcabi.github.mock.MkPublicKeys;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUserEmails;
import com.jcabi.github.mock.MkUserOrganizations;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.json.Json;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class MkUser
implements User {
    private final transient MkStorage storage;
    private final transient String self;

    MkUser(MkStorage stg, String login) throws IOException {
        this.storage = stg;
        this.self = login;
    }

    @Override
    public Github github() {
        return new MkGithub(this.storage, this.self);
    }

    @Override
    public String login() {
        return this.self;
    }

    @Override
    public UserOrganizations organizations() {
        try {
            return new MkUserOrganizations(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public PublicKeys keys() {
        try {
            return new MkPublicKeys(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public UserEmails emails() {
        try {
            return new MkUserEmails(this.storage, this.self);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Notifications notifications() {
        return new MkNotifications(this.storage, this.xpath().concat("/notifications/notification"));
    }

    @Override
    public void markAsRead(Date lastread) throws IOException {
        List ids = this.storage.xml().nodes(this.xpath() + String.format("/notifications/notification[date <= %s]/id", lastread.getTime()));
        JsonPatch json = new JsonPatch(this.storage);
        JsonObject read = Json.createObjectBuilder().add("read", true).build();
        for (XML nid : ids) {
            json.patch(String.format(this.xpath().concat("/notifications/notification[id = %s]"), nid.xpath("text()").get(0)), read);
        }
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    private String xpath() {
        return String.format("/github/users/user[login='%s']", this.self);
    }

    public String toString() {
        return "MkUser(storage=" + this.storage + ", self=" + this.self + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkUser)) {
            return false;
        }
        MkUser other = (MkUser)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

