/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Content;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Issue;
import com.jcabi.github.Repo;
import com.jcabi.github.Search;
import com.jcabi.github.User;
import com.jcabi.github.mock.MkContent;
import com.jcabi.github.mock.MkGithub;
import com.jcabi.github.mock.MkIssue;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.github.mock.MkUser;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.EnumMap;

@Immutable
@Loggable(value=1)
final class MkSearch
implements Search {
    private final transient MkStorage storage;
    private final transient String self;

    MkSearch(MkStorage stg, String login) {
        this.storage = stg;
        this.self = login;
    }

    @Override
    public Github github() {
        return new MkGithub(this.storage, this.self);
    }

    @Override
    public Iterable<Repo> repos(String keywords, String sort, Search.Order order) throws IOException {
        return new MkIterable<Repo>(this.storage, "/github/repos/repo", new MkIterable.Mapping<Repo>(){

            @Override
            public Repo map(XML xml) {
                return new MkRepo(MkSearch.this.storage, MkSearch.this.self, new Coordinates.Simple((String)xml.xpath("@coords").get(0)));
            }
        });
    }

    @Override
    public Iterable<Issue> issues(String keywords, String sort, Search.Order order, EnumMap<Search.Qualifier, String> qualifiers) throws IOException {
        return new MkIterable<Issue>(this.storage, "/github/repos/repo/issues/issue", new MkIterable.Mapping<Issue>(){

            @Override
            public Issue map(XML xml) {
                return new MkIssue(MkSearch.this.storage, MkSearch.this.self, new Coordinates.Simple((String)xml.xpath("../../@coords").get(0)), Integer.parseInt((String)xml.xpath("number/text()").get(0)));
            }
        });
    }

    @Override
    public Iterable<User> users(String keywords, String sort, Search.Order order) throws IOException {
        return new MkIterable<User>(this.storage, "/github/users/user", new MkIterable.Mapping<User>(){

            @Override
            public User map(XML xml) {
                try {
                    return new MkUser(MkSearch.this.storage, (String)xml.xpath("login/text()").get(0));
                }
                catch (IOException ex) {
                    throw new IllegalStateException(ex);
                }
            }
        });
    }

    @Override
    public Iterable<Content> codes(String keywords, String sort, Search.Order order) throws IOException {
        return new MkIterable<Content>(this.storage, "/github/repos/repo/name", new MkIterable.Mapping<Content>(){

            @Override
            public Content map(XML xml) {
                try {
                    return new MkContent(MkSearch.this.storage, MkSearch.this.self, new Coordinates.Simple(MkSearch.this.self, "repo"), "/path/to/search", "master");
                }
                catch (IOException exception) {
                    throw new IllegalStateException(exception);
                }
            }
        });
    }

    public String toString() {
        return "MkSearch(storage=" + this.storage + ", self=" + this.self + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkSearch)) {
            return false;
        }
        MkSearch other = (MkSearch)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

