/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Github;
import com.jcabi.github.Repo;
import com.jcabi.github.Repos;
import com.jcabi.github.mock.MkGithub;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.log.Logger;
import com.jcabi.xml.XML;
import java.io.IOException;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkRepos
implements Repos {
    private final transient MkStorage storage;
    private final transient String self;

    MkRepos(MkStorage stg, String login) throws IOException {
        this.storage = stg;
        this.self = login;
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)"/github").addIf((Object)"repos"));
    }

    @Override
    public Github github() {
        return new MkGithub(this.storage, this.self);
    }

    @Override
    public Repo create(Repos.RepoCreate settings) throws IOException {
        String owner = this.self;
        String org = settings.organization();
        if (org != null && !org.isEmpty()) {
            owner = "/orgs/".concat(org).concat("/repos");
        }
        Coordinates.Simple coords = new Coordinates.Simple(owner, settings.name());
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).add((Object)"repo").attr((Object)"coords", (Object)((Object)coords).toString()).add((Object)"name").set((Object)settings.name()).up().add((Object)"description").set((Object)"test repository").up().add((Object)"private").set((Object)settings.isPrivate()).up());
        Repo repo = this.get(coords);
        repo.patch(settings.json());
        Logger.info((Object)this, (String)"repository %s created by %s", (Object[])new Object[]{coords, owner});
        return repo;
    }

    @Override
    public Repo get(Coordinates coords) {
        try {
            String xpath = String.format("%s/repo[@coords='%s']", this.xpath(), coords);
            if (this.storage.xml().nodes(xpath).isEmpty()) {
                throw new IllegalArgumentException(String.format("repository %s doesn't exist", coords));
            }
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
        return new MkRepo(this.storage, this.self, coords);
    }

    @Override
    public void remove(Coordinates coords) {
        try {
            this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)String.format("%s/repo[@coords='%s']", this.xpath(), coords)).remove());
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Iterable<Repo> iterate(String identifier) {
        return new MkIterable<Repo>(this.storage, "/github/repos/repo", new MkIterable.Mapping<Repo>(){

            @Override
            public Repo map(XML xml) {
                return new MkRepo(MkRepos.this.storage, MkRepos.this.self, new Coordinates.Simple((String)xml.xpath("@coords").get(0)));
            }
        });
    }

    @Override
    public boolean exists(Coordinates coords) throws IOException {
        String xpath = String.format("%s/repo[@coords='%s']", this.xpath(), coords);
        return !this.storage.xml().nodes(xpath).isEmpty();
    }

    private String xpath() {
        return "/github/repos";
    }

    public String toString() {
        return "MkRepos(storage=" + this.storage + ", self=" + this.self + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkRepos)) {
            return false;
        }
        MkRepos other = (MkRepos)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        return !(this$self == null ? other$self != null : !this$self.equals(other$self));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        return result;
    }
}

