/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Gist;
import com.jcabi.github.GistComments;
import com.jcabi.github.Github;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkGithub;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.List;
import javax.json.JsonObject;
import org.apache.commons.lang3.StringUtils;
import org.xembly.Directive;
import org.xembly.Directives;

@Immutable
@Loggable(value=1)
final class MkGist
implements Gist {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient String gist;

    MkGist(MkStorage stg, String login, String name) {
        this.storage = stg;
        this.self = login;
        this.gist = name;
    }

    @Override
    public Github github() {
        return new MkGithub(this.storage, this.self);
    }

    @Override
    public String identifier() {
        return this.gist;
    }

    @Override
    public String read(String file) throws IOException {
        List files = this.storage.xml().nodes(String.format("%s/files/file[filename='%s']", this.xpath(), file));
        if (files.isEmpty()) {
            throw new IOException(String.format("Couldn't find file with the name %s.", file));
        }
        List contents = ((XML)files.get(0)).xpath("raw_content/text()");
        String content = "";
        if (!contents.isEmpty()) {
            content = (String)contents.get(0);
        }
        return content;
    }

    @Override
    public void write(String file, String content) throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).xpath((Object)String.format("files[not(file[filename='%s'])]", file)).add((Object)"file").add((Object)"filename").set((Object)file).up().add((Object)"raw_content"));
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).xpath((Object)String.format("files/file[filename='%s']/raw_content", file)).set((Object)content));
    }

    @Override
    public void star() throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).attr((Object)"starred", (Object)Boolean.toString(true)));
    }

    @Override
    public void unstar() throws IOException {
        this.storage.apply((Iterable<Directive>)new Directives().xpath((Object)this.xpath()).attr((Object)"starred", (Object)Boolean.toString(false)));
    }

    @Override
    public boolean starred() throws IOException {
        List xpath = this.storage.xml().xpath(String.format("%s/@starred", this.xpath()));
        return !xpath.isEmpty() && StringUtils.equalsIgnoreCase((CharSequence)Boolean.toString(true), (CharSequence)((CharSequence)xpath.get(0)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Gist fork() throws IOException {
        String number;
        this.storage.lock();
        try {
            XML xml = this.storage.xml();
            number = Integer.toString(1 + xml.xpath("/github/gists/gist/id/text()").size());
            Directives dirs = new Directives().xpath((Object)"/github/gists").add((Object)"gist").add((Object)"id").set((Object)number).up().add((Object)"files");
            List files = xml.nodes(String.format("%s/files/file", this.xpath()));
            for (XML file : files) {
                String filename = (String)file.xpath("filename/text()").get(0);
                dirs.add((Object)"file").add((Object)"filename").set((Object)filename).up().add((Object)"raw_content").set((Object)this.read(filename)).up().up();
            }
            this.storage.apply((Iterable<Directive>)dirs);
        }
        finally {
            this.storage.unlock();
        }
        return new MkGist(this.storage, this.self, number);
    }

    @Override
    public GistComments comments() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public JsonObject json() throws IOException {
        return new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        new JsonPatch(this.storage).patch(this.xpath(), json);
    }

    private String xpath() {
        return String.format("/github/gists/gist[id='%s']", this.gist);
    }

    public String toString() {
        return "MkGist(storage=" + this.storage + ", self=" + this.self + ", gist=" + this.gist + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkGist)) {
            return false;
        }
        MkGist other = (MkGist)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        String this$gist = this.gist;
        String other$gist = other.gist;
        return !(this$gist == null ? other$gist != null : !this$gist.equals(other$gist));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        String $gist = this.gist;
        result = result * 59 + ($gist == null ? 43 : $gist.hashCode());
        return result;
    }
}

