/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.google.common.collect.ImmutableList;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.CommitsComparison;
import com.jcabi.github.Coordinates;
import com.jcabi.github.FileChange;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.MkFileChange;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonValue;

@Immutable
@Loggable(value=1)
final class MkCommitsComparison
implements CommitsComparison {
    private static final JsonObject FILE_JSON = Json.createObjectBuilder().add("sha", "bbcd538c8e72b8c175046e27cc8f907076331401").add("filename", "test-file").add("status", "modified").build();
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;

    MkCommitsComparison(MkStorage stg, String login, Coordinates repo) {
        this.storage = stg;
        this.self = login;
        this.coords = repo;
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public JsonObject json() throws IOException {
        return Json.createObjectBuilder().add("status", "test-status").add("ahead_by", 1).add("behind_by", 2).add("author", (JsonValue)Json.createObjectBuilder().add("login", "test").build()).add("files", (JsonValue)Json.createArrayBuilder().add((JsonValue)FILE_JSON).build()).add("commits", (JsonValue)Json.createArrayBuilder().build()).build();
    }

    @Override
    public Iterable<FileChange> files() {
        return ImmutableList.of((Object)new MkFileChange(FILE_JSON));
    }

    public String toString() {
        return "MkCommitsComparison(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ")";
    }
}

