/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Github;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtUser;
import com.jcabi.github.RtValuePagination;
import com.jcabi.github.User;
import com.jcabi.github.Users;
import com.jcabi.http.Request;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtUsers
implements Users {
    private final transient Request entry;
    private final transient Github ghub;
    private final transient Request request;

    RtUsers(Github github, Request req) {
        this.entry = req;
        this.ghub = github;
        this.request = this.entry.uri().path("/users").back();
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Github github() {
        return this.ghub;
    }

    @Override
    public User self() {
        return new RtUser(this.ghub, this.entry, "");
    }

    @Override
    public User get(String login) {
        return new RtUser(this.ghub, this.entry, login);
    }

    @Override
    public User add(String login) {
        throw new UnsupportedOperationException("#add not implemented");
    }

    @Override
    public Iterable<User> iterate(String identifier) {
        return new RtPagination<User>(this.request.uri().queryParam("since", (Object)identifier).back(), new RtValuePagination.Mapping<User, JsonObject>(){

            @Override
            public User map(JsonObject object) {
                return RtUsers.this.get(String.valueOf(object.getInt("id")));
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtUsers)) {
            return false;
        }
        RtUsers other = (RtUsers)o;
        Github this$ghub = this.ghub;
        Github other$ghub = other.ghub;
        if (this$ghub == null ? other$ghub != null : !this$ghub.equals(other$ghub)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        return !(this$request == null ? other$request != null : !this$request.equals(other$request));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Github $ghub = this.ghub;
        result = result * 59 + ($ghub == null ? 43 : $ghub.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        return result;
    }
}

