/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.CommitsComparison;
import com.jcabi.github.Repo;
import com.jcabi.github.RepoCommit;
import com.jcabi.github.RepoCommits;
import com.jcabi.github.RtCommitsComparison;
import com.jcabi.github.RtJson;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtRepoCommit;
import com.jcabi.github.RtValuePagination;
import com.jcabi.http.Request;
import com.jcabi.http.RequestURI;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import java.util.Map;
import javax.json.JsonObject;

@Immutable
@Loggable(value=1)
final class RtRepoCommits
implements RepoCommits {
    private final transient Request entry;
    private final transient Request request;
    private final transient Request comp;
    private final transient Repo owner;

    RtRepoCommits(Request req, Repo repo) {
        this.entry = req;
        this.owner = repo;
        RequestURI rep = req.uri().path("/repos").path(repo.coordinates().user()).path(repo.coordinates().repo());
        this.request = rep.path("/commits").back();
        this.comp = rep.path("/compare").back();
    }

    @Override
    public Iterable<RepoCommit> iterate(Map<String, String> params) {
        return new RtPagination<RepoCommit>(this.request.uri().queryParams(params).back(), new RtValuePagination.Mapping<RepoCommit, JsonObject>(){

            @Override
            public RepoCommit map(JsonObject value) {
                return RtRepoCommits.this.get(value.getString("sha"));
            }
        });
    }

    @Override
    public RepoCommit get(String sha) {
        return new RtRepoCommit(this.entry, this.owner, sha);
    }

    @Override
    public CommitsComparison compare(String base, String head) {
        return new RtCommitsComparison(this.entry, this.owner, base, head);
    }

    @Override
    public String diff(String base, String head) throws IOException {
        return ((RestResponse)this.comp.reset("Accept").header("Accept", (Object)"application/vnd.github.v3.diff").uri().path(String.format("%s...%s", base, head)).back().fetch().as(RestResponse.class)).assertStatus(200).body();
    }

    @Override
    public String patch(String base, String head) throws IOException {
        return ((RestResponse)this.comp.reset("Accept").header("Accept", (Object)"application/vnd.github.v3.patch").uri().path(String.format("%s...%s", base, head)).back().fetch().as(RestResponse.class)).assertStatus(200).body();
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public JsonObject json() throws IOException {
        return new RtJson(this.request).fetch();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtRepoCommits)) {
            return false;
        }
        RtRepoCommits other = (RtRepoCommits)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Request this$request = this.request;
        Request other$request = other.request;
        if (this$request == null ? other$request != null : !this$request.equals(other$request)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Request $request = this.request;
        result = result * 59 + ($request == null ? 43 : $request.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

