/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Label;
import com.jcabi.github.Labels;
import com.jcabi.github.Repo;
import com.jcabi.github.RtLabel;
import com.jcabi.github.RtPagination;
import com.jcabi.github.RtValuePagination;
import com.jcabi.http.Request;
import com.jcabi.http.response.JsonResponse;
import com.jcabi.http.response.RestResponse;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonStructure;

@Immutable
@Loggable(value=1)
final class RtLabels
implements Labels {
    private final transient Request entry;
    private final transient Request request;
    private final transient Repo owner;

    RtLabels(Request req, Repo repo) {
        this.owner = repo;
        Coordinates coords = repo.coordinates();
        this.entry = req;
        this.request = req.uri().path("/repos").path(coords.user()).path(coords.repo()).path("/labels").back();
    }

    public String toString() {
        return this.request.uri().get().toString();
    }

    @Override
    public Repo repo() {
        return this.owner;
    }

    @Override
    public Label create(String name, String color) throws IOException {
        JsonObject json = Json.createObjectBuilder().add("name", name).add("color", color).build();
        ((JsonResponse)((RestResponse)this.request.method("POST").body().set((JsonStructure)json).back().fetch().as(RestResponse.class)).assertStatus(201).as(JsonResponse.class)).json();
        return new RtLabel(this.entry, this.owner, name);
    }

    @Override
    public Label get(String name) {
        return new RtLabel(this.entry, this.owner, name);
    }

    @Override
    public void delete(String name) throws IOException {
        ((RestResponse)this.request.method("DELETE").uri().path(name).back().fetch().as(RestResponse.class)).assertStatus(204);
    }

    @Override
    public Iterable<Label> iterate() {
        return new RtPagination<Label>(this.request, new RtValuePagination.Mapping<Label, JsonObject>(){

            @Override
            public Label map(JsonObject object) {
                return new RtLabel(RtLabels.this.entry, RtLabels.this.owner, object.getString("name"));
            }
        });
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RtLabels)) {
            return false;
        }
        RtLabels other = (RtLabels)o;
        Request this$entry = this.entry;
        Request other$entry = other.entry;
        if (this$entry == null ? other$entry != null : !this$entry.equals(other$entry)) {
            return false;
        }
        Repo this$owner = this.owner;
        Repo other$owner = other.owner;
        return !(this$owner == null ? other$owner != null : !this$owner.equals(other$owner));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Request $entry = this.entry;
        result = result * 59 + ($entry == null ? 43 : $entry.hashCode());
        Repo $owner = this.owner;
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        return result;
    }
}

