/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.google.common.base.Optional;
import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Comments;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Event;
import com.jcabi.github.Issue;
import com.jcabi.github.IssueLabels;
import com.jcabi.github.Label;
import com.jcabi.github.Reaction;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.JsonPatch;
import com.jcabi.github.mock.MkComments;
import com.jcabi.github.mock.MkIssueEvents;
import com.jcabi.github.mock.MkIssueLabels;
import com.jcabi.github.mock.MkIterable;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import java.util.Collection;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

@Immutable
@Loggable(value=1)
final class MkIssue
implements Issue {
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient int num;

    MkIssue(MkStorage stg, String login, Coordinates rep, int number) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.num = number;
    }

    public String toString() {
        return Integer.toString(this.num);
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public Comments comments() {
        try {
            return new MkComments(this.storage, this.self, this.coords, this.num);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public IssueLabels labels() {
        try {
            return new MkIssueLabels(this.storage, this.self, this.coords, this.num);
        }
        catch (IOException ex) {
            throw new IllegalStateException(ex);
        }
    }

    @Override
    public Iterable<Event> events() throws IOException {
        return new MkIterable<Event>(this.storage, String.format("/github/repos/repo[@coords='%s']/issue-events/issue-event[issue='%s']", this.coords, this.num), new MkIssueEventMapping(this));
    }

    @Override
    public boolean exists() throws IOException {
        return this.storage.xml().xpath(String.format("%s/number/text()", this.xpath())).size() == 1;
    }

    @Override
    public int compareTo(Issue issue) {
        return this.number() - issue.number();
    }

    @Override
    public void patch(JsonObject json) throws IOException {
        Issue.Smart smart = new Issue.Smart(this);
        boolean was = smart.isOpen();
        new JsonPatch(this.storage).patch(this.xpath(), json);
        boolean now = smart.isOpen();
        if (now != was) {
            String type = now ? "reopened" : "closed";
            new MkIssueEvents(this.storage, this.self, this.coords).create(type, this.num, this.self, (Optional<String>)Optional.absent());
        }
    }

    @Override
    public JsonObject json() throws IOException {
        XML xml = this.storage.xml();
        JsonObject obj = new JsonNode((XML)xml.nodes(this.xpath()).get(0)).json();
        JsonObjectBuilder json = Json.createObjectBuilder();
        for (Object val : obj.entrySet()) {
            json.add((String)val.getKey(), (JsonValue)val.getValue());
        }
        JsonArrayBuilder array = Json.createArrayBuilder();
        for (Label label : this.labels().iterate()) {
            array.add((JsonValue)Json.createObjectBuilder().add("name", label.name()).build());
        }
        JsonObjectBuilder res = json.add("labels", array).add("assignee", (JsonValue)Json.createObjectBuilder().add("login", obj.getString("assignee", "")).build());
        JsonObjectBuilder pull = Json.createObjectBuilder();
        String html = "html_url";
        if (xml.nodes(String.format("/github/repos/repo[@coords='%s']/pulls/pull/number[text() = '%d']", this.coords, this.num)).isEmpty()) {
            pull.addNull("html_url");
        } else {
            pull.add("html_url", String.format("https://%s/pulls/%d", this.coords, this.num));
        }
        return res.add("pull_request", (JsonValue)pull.build()).build();
    }

    @Override
    public void react(Reaction reaction) {
        throw new UnsupportedOperationException("react() not implemented");
    }

    public Collection<Reaction> reactions() {
        throw new UnsupportedOperationException("reactions() not implemented");
    }

    @Override
    public void lock(String reason) {
        throw new UnsupportedOperationException("lock not implemented");
    }

    @Override
    public void unlock() {
        throw new UnsupportedOperationException("unlock not implemented");
    }

    @Override
    public boolean isLocked() {
        throw new UnsupportedOperationException("isLocked not implemented");
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/issues/issue[number='%d']", this.coords, this.num);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkIssue)) {
            return false;
        }
        MkIssue other = (MkIssue)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        if (this$coords == null ? other$coords != null : !this$coords.equals(other$coords)) {
            return false;
        }
        return this.num == other.num;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        result = result * 59 + this.num;
        return result;
    }

    private static class MkIssueEventMapping
    implements MkIterable.Mapping<Event> {
        private final transient MkIssueEvents evts;

        public MkIssueEventMapping(MkIssue issue) throws IOException {
            this.evts = new MkIssueEvents(issue.storage, issue.self, issue.coords);
        }

        @Override
        public Event map(XML xml) {
            return this.evts.get(Integer.parseInt((String)xml.xpath("number/text()").get(0)));
        }
    }
}

