/*
 * Decompiled with CFR 0.152.
 */
package com.jcabi.github.mock;

import com.jcabi.aspects.Immutable;
import com.jcabi.aspects.Loggable;
import com.jcabi.github.Coordinates;
import com.jcabi.github.Event;
import com.jcabi.github.Repo;
import com.jcabi.github.mock.JsonNode;
import com.jcabi.github.mock.MkRepo;
import com.jcabi.github.mock.MkStorage;
import com.jcabi.xml.XML;
import java.io.IOException;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

@Immutable
@Loggable(value=1)
final class MkEvent
implements Event {
    private static final String CREATED_AT = "created_at";
    private static final String EVENT = "event";
    private static final String LOGIN = "login";
    private final transient MkStorage storage;
    private final transient String self;
    private final transient Coordinates coords;
    private final transient int num;

    MkEvent(MkStorage stg, String login, Coordinates rep, int nmbr) {
        this.storage = stg;
        this.self = login;
        this.coords = rep;
        this.num = nmbr;
    }

    @Override
    public Repo repo() {
        return new MkRepo(this.storage, this.self, this.coords);
    }

    @Override
    public int number() {
        return this.num;
    }

    @Override
    public int compareTo(Event event) {
        throw new UnsupportedOperationException("#compareTo()");
    }

    @Override
    public JsonObject json() throws IOException {
        JsonObject obj = new JsonNode((XML)this.storage.xml().nodes(this.xpath()).get(0)).json();
        JsonObjectBuilder builder = Json.createObjectBuilder().add("id", this.num).add("url", String.format("https://api.jcabi-github.invalid/repos/%s/issues/events/%s", this.coords, this.num)).add("commit_id", JsonValue.NULL).add(EVENT, obj.getString(EVENT)).add("actor", (JsonValue)Json.createObjectBuilder().add(LOGIN, obj.getString(LOGIN)).build()).add(CREATED_AT, obj.getString(CREATED_AT));
        String label = "label";
        if (obj.containsKey((Object)"label")) {
            builder = builder.add("label", (JsonValue)Json.createObjectBuilder().add("name", obj.getString("label")).build());
        }
        return builder.build();
    }

    private String xpath() {
        return String.format("/github/repos/repo[@coords='%s']/issue-events/issue-event[number='%d']", this.coords, this.num);
    }

    public String toString() {
        return "MkEvent(storage=" + this.storage + ", self=" + this.self + ", coords=" + this.coords + ", num=" + this.num + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MkEvent)) {
            return false;
        }
        MkEvent other = (MkEvent)o;
        MkStorage this$storage = this.storage;
        MkStorage other$storage = other.storage;
        if (this$storage == null ? other$storage != null : !this$storage.equals(other$storage)) {
            return false;
        }
        String this$self = this.self;
        String other$self = other.self;
        if (this$self == null ? other$self != null : !this$self.equals(other$self)) {
            return false;
        }
        Coordinates this$coords = this.coords;
        Coordinates other$coords = other.coords;
        if (this$coords == null ? other$coords != null : !this$coords.equals(other$coords)) {
            return false;
        }
        return this.num == other.num;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MkStorage $storage = this.storage;
        result = result * 59 + ($storage == null ? 43 : $storage.hashCode());
        String $self = this.self;
        result = result * 59 + ($self == null ? 43 : $self.hashCode());
        Coordinates $coords = this.coords;
        result = result * 59 + ($coords == null ? 43 : $coords.hashCode());
        result = result * 59 + this.num;
        return result;
    }
}

