/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.internal.token;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.InvalidPathException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.internal.PathRef;
import com.jayway.jsonpath.internal.token.EvaluationContextImpl;
import com.jayway.jsonpath.internal.token.PathToken;
import com.jayway.jsonpath.internal.token.PredicateContextImpl;
import java.util.Arrays;
import java.util.Collection;

public class PredicatePathToken
extends PathToken {
    private static final String[] FRAGMENTS = new String[]{"[?]", "[?,?]", "[?,?,?]", "[?,?,?,?]", "[?,?,?,?,?]"};
    private final Collection<Predicate> predicates;

    public PredicatePathToken(Predicate filter) {
        this.predicates = Arrays.asList(filter);
    }

    public PredicatePathToken(Collection<Predicate> predicates) {
        this.predicates = predicates;
    }

    @Override
    public void evaluate(String currentPath, PathRef ref, Object model, EvaluationContextImpl ctx) {
        if (ctx.jsonProvider().isMap(model)) {
            if (this.accept(model, ctx.rootDocument(), ctx.configuration(), ctx)) {
                PathRef op;
                PathRef pathRef = op = ctx.forUpdate() ? ref : PathRef.NO_OP;
                if (this.isLeaf()) {
                    ctx.addResult(currentPath, op, model);
                } else {
                    this.next().evaluate(currentPath, op, model, ctx);
                }
            }
        } else if (ctx.jsonProvider().isArray(model)) {
            int idx = 0;
            Iterable<?> objects = ctx.jsonProvider().toIterable(model);
            for (Object idxModel : objects) {
                if (this.accept(idxModel, ctx.rootDocument(), ctx.configuration(), ctx)) {
                    this.handleArrayIndex(idx, currentPath, model, ctx);
                }
                ++idx;
            }
        } else {
            throw new InvalidPathException(String.format("Filter: %s can not be applied to primitives. Current context is: %s", this.toString(), model));
        }
    }

    public boolean accept(Object obj, Object root, Configuration configuration, EvaluationContextImpl evaluationContext) {
        PredicateContextImpl ctx = new PredicateContextImpl(obj, root, configuration, evaluationContext.documentEvalCache());
        for (Predicate predicate : this.predicates) {
            if (predicate.apply(ctx)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getPathFragment() {
        return FRAGMENTS[this.predicates.size() - 1];
    }

    @Override
    boolean isTokenDefinite() {
        return false;
    }
}

