/*
 * Decompiled with CFR 0.152.
 */
package com.jayway.jsonpath.filter;

import com.jayway.jsonpath.JsonUtil;
import com.jayway.jsonpath.eval.ExpressionEvaluator;
import com.jayway.jsonpath.filter.JsonPathFilterBase;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.simple.JSONArray;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListFilter
extends JsonPathFilterBase {
    private static final Pattern LIST_INDEX_PATTERN = Pattern.compile("\\[(\\s?\\d+\\s?,?)+\\]");
    private static final Pattern LIST_PULL_PATTERN = Pattern.compile("\\[\\s?:(\\d+)\\s?\\]");
    private static final Pattern LIST_WILDCARD_PATTERN = Pattern.compile("\\[\\*\\]");
    private static final Pattern LIST_TAIL_PATTERN_SHORT = Pattern.compile("\\[\\s*-\\s*(\\d+):\\s*\\]");
    private static final Pattern LIST_TAIL_PATTERN_LONG = Pattern.compile("\\[\\s*\\(\\s*@\\.length\\s*-\\s*(\\d+)\\s*\\)\\s*\\]");
    private static final Pattern LIST_TAIL_PATTERN = Pattern.compile("(" + LIST_TAIL_PATTERN_SHORT.pattern() + "|" + LIST_TAIL_PATTERN_LONG.pattern() + ")");
    private static final Pattern LIST_ITEM_HAS_PROPERTY_PATTERN = Pattern.compile("\\[\\s?\\?\\s?\\(\\s?@\\.(\\w+)\\s?\\)\\s?\\]");
    private static final Pattern LIST_ITEM_MATCHES_EVAL = Pattern.compile("\\[\\s?\\?\\s?\\(\\s?@.(\\w+)\\s?([=<>]+)\\s?(.*)\\s?\\)\\s?\\]");
    private final String pathFragment;

    public ListFilter(String pathFragment) {
        this.pathFragment = pathFragment;
    }

    @Override
    public List<Object> apply(List<Object> items) {
        JSONArray result = new JSONArray();
        if (LIST_INDEX_PATTERN.matcher(this.pathFragment).matches()) {
            return this.filterByListIndex(items);
        }
        if (LIST_WILDCARD_PATTERN.matcher(this.pathFragment).matches()) {
            return this.filterByWildcard(items);
        }
        if (LIST_TAIL_PATTERN.matcher(this.pathFragment).matches()) {
            return this.filterByListTailIndex(items);
        }
        if (LIST_PULL_PATTERN.matcher(this.pathFragment).matches()) {
            return this.filterByPullIndex(items);
        }
        if (LIST_ITEM_HAS_PROPERTY_PATTERN.matcher(this.pathFragment).matches()) {
            return this.filterByItemProperty(items);
        }
        if (LIST_ITEM_MATCHES_EVAL.matcher(this.pathFragment).matches()) {
            return this.filterByItemEvalMatch(items);
        }
        return result;
    }

    private List<Object> filterByItemEvalMatch(List<Object> items) {
        JSONArray result = new JSONArray();
        for (Object current : items) {
            for (Object item : JsonUtil.toList(current)) {
                if (!this.isEvalMatch(item)) continue;
                result.add(item);
            }
        }
        return result;
    }

    private List<Object> filterByItemProperty(List<Object> items) {
        JSONArray result = new JSONArray();
        String prop = this.getFilterProperty();
        for (Object current : items) {
            for (Object item : JsonUtil.toList(current)) {
                if (!JsonUtil.isMap(item) || !JsonUtil.toMap(item).containsKey(prop)) continue;
                result.add(item);
            }
        }
        return result;
    }

    private List<Object> filterByWildcard(List<Object> items) {
        JSONArray result = new JSONArray();
        for (Object current : items) {
            result.addAll(JsonUtil.toList(current));
        }
        return result;
    }

    private List<Object> filterByListTailIndex(List<Object> items) {
        JSONArray result = new JSONArray();
        for (Object current : items) {
            List<Object> array = JsonUtil.toList(current);
            result.add(array.get(this.getTailIndex(array.size())));
        }
        return result;
    }

    private List<Object> filterByListIndex(List<Object> items) {
        JSONArray result = new JSONArray();
        for (Object current : items) {
            Integer[] index;
            List<Object> target = JsonUtil.toList(current);
            Integer[] arr$ = index = this.getArrayIndex();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                if (!this.indexIsInRange(target, i)) continue;
                result.add(target.get(i));
            }
        }
        return result;
    }

    private List<Object> filterByPullIndex(List<Object> items) {
        JSONArray result = new JSONArray();
        for (Object current : items) {
            Integer[] index;
            List<Object> target = JsonUtil.toList(current);
            Integer[] arr$ = index = this.getListPullIndex();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                int i = arr$[i$];
                if (!this.indexIsInRange(target, i)) continue;
                result.add(target.get(i));
            }
        }
        return result;
    }

    private boolean isEvalMatch(Object check) {
        Matcher matcher = LIST_ITEM_MATCHES_EVAL.matcher(this.pathFragment);
        if (matcher.matches()) {
            String property = matcher.group(1);
            String operator = matcher.group(2);
            String expected = matcher.group(3);
            if (!JsonUtil.isMap(check)) {
                return false;
            }
            Map<Object, Object> obj = JsonUtil.toMap(check);
            if (!obj.containsKey(property)) {
                return false;
            }
            Object propertyValue = obj.get(property);
            if (JsonUtil.isContainer(propertyValue)) {
                return false;
            }
            String expression = propertyValue + " " + operator + " " + expected;
            return ExpressionEvaluator.eval(propertyValue, operator, expected);
        }
        return false;
    }

    private String getFilterProperty() {
        Matcher matcher = LIST_ITEM_HAS_PROPERTY_PATTERN.matcher(this.pathFragment);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        throw new IllegalArgumentException("invalid list filter property");
    }

    private int getTailIndex(int arraySize) {
        Matcher matcher = LIST_TAIL_PATTERN_SHORT.matcher(this.pathFragment);
        if (matcher.matches()) {
            int index = Integer.parseInt(matcher.group(1));
            return arraySize - index;
        }
        matcher = LIST_TAIL_PATTERN_LONG.matcher(this.pathFragment);
        if (matcher.matches()) {
            int index = Integer.parseInt(matcher.group(1));
            return arraySize - index;
        }
        throw new IllegalArgumentException("invalid list index");
    }

    private Integer[] getListPullIndex() {
        Matcher matcher = LIST_PULL_PATTERN.matcher(this.pathFragment);
        if (matcher.matches()) {
            int pullCount = Integer.parseInt(matcher.group(1));
            LinkedList<Integer> result = new LinkedList<Integer>();
            for (int y = 0; y < pullCount; ++y) {
                result.add(y);
            }
            return result.toArray(new Integer[0]);
        }
        throw new IllegalArgumentException("invalid list index");
    }

    private Integer[] getArrayIndex() {
        String[] split;
        String prepared = this.pathFragment.replaceAll(" ", "");
        prepared = prepared.substring(1, prepared.length() - 1);
        LinkedList<Integer> index = new LinkedList<Integer>();
        for (String s : split = prepared.split(",")) {
            index.add(Integer.parseInt(s));
        }
        return index.toArray(new Integer[0]);
    }

    private boolean indexIsInRange(List list, int index) {
        if (index < 0) {
            return false;
        }
        return index <= list.size() - 1;
    }
}

