/*
 * Decompiled with CFR 0.152.
 */
package scriptella.tools.ant;

import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.apache.tools.ant.Project;

public class AntHandler
extends Handler {
    private StringBuilder sb = new StringBuilder();
    private boolean debug;
    private Project project;

    public AntHandler(Project project, boolean debug) {
        this.project = project;
        this.debug = debug;
    }

    public synchronized void publish(LogRecord record) {
        int lev;
        Throwable thrown;
        String msg = record.getMessage();
        if (msg != null) {
            this.sb.append(msg);
        }
        if ((thrown = record.getThrown()) != null) {
            this.sb.append("\n").append(thrown.toString()).append('\n');
        }
        if ((lev = this.convert(record.getLevel())) >= 0) {
            this.project.log(this.sb.toString(), lev);
        }
        this.sb.setLength(0);
    }

    private int convert(Level level) {
        int lev = level.intValue();
        if (lev >= Level.SEVERE.intValue()) {
            return 0;
        }
        if (lev >= Level.WARNING.intValue()) {
            return 1;
        }
        if (lev >= Level.INFO.intValue()) {
            return 2;
        }
        if (this.debug) {
            return 2;
        }
        if (lev >= Level.FINE.intValue()) {
            return 3;
        }
        if (lev > Level.OFF.intValue()) {
            return 4;
        }
        return -1;
    }

    public void flush() {
    }

    public void close() {
    }
}

