/*
 * Decompiled with CFR 0.152.
 */
package scriptella.tools.launcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import scriptella.core.ExceptionInterceptor;
import scriptella.core.SystemException;
import scriptella.execution.EtlExecutorException;

public class BugReport {
    private Throwable throwable;

    public BugReport(Throwable throwable) {
        this.throwable = throwable;
    }

    public static boolean isPossibleBug(Throwable throwable) {
        if (throwable instanceof ExceptionInterceptor.ExecutionException) {
            if (throwable.getCause() != null) {
                return BugReport.isPossibleBug(throwable.getCause());
            }
            return true;
        }
        if (throwable instanceof EtlExecutorException) {
            if (throwable.getCause() != null) {
                return BugReport.isPossibleBug(throwable.getCause());
            }
            return true;
        }
        return !(throwable instanceof SystemException);
    }

    public String toString() {
        StringWriter rep = new StringWriter();
        PrintWriter pw = new PrintWriter(rep);
        pw.println("Scriptella bug report. Submit to issue tracker.");
        Package p = BugReport.class.getPackage();
        String version = p != null && p.getImplementationVersion() != null ? p.getImplementationVersion() : "Unknown";
        pw.println("Scriptella version: " + version);
        pw.println("Exception: ");
        this.throwable.printStackTrace(pw);
        pw.println("Environment: ");
        pw.println(System.getenv());
        pw.println("System properties: ");
        pw.println(System.getProperties());
        pw.println("-----------------------------------------------------------------");
        return rep.toString();
    }
}

