/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webdav.lib.methods;

import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import org.apache.webdav.lib.PropertyName;
import org.apache.webdav.lib.util.XMLPrinter;

public class PropertyBodyHelper {
    protected PropertyName[] propertyNames;

    protected void setPropertyNames(Collection propertyNames) {
        Vector list = new Vector();
        Iterator propertyIterator = propertyNames.iterator();
        while (propertyIterator.hasNext()) {
            Object item = propertyIterator.next();
            if (item instanceof PropertyName) {
                list.add(item);
                continue;
            }
            if (!(item instanceof String)) continue;
            String propertyName = (String)item;
            int length = propertyName.length();
            boolean found = false;
            int i2 = 1;
            while (!found && i2 <= length) {
                char chr = propertyName.charAt(length - i2);
                if (!Character.isUnicodeIdentifierPart(chr) && chr != '-' && chr != '_' && chr != '.') {
                    found = true;
                    continue;
                }
                ++i2;
            }
            if (i2 == 1 || i2 >= length) {
                list.add(new PropertyName("DAV:", propertyName));
                continue;
            }
            String namespace = propertyName.substring(0, length + 1 - i2);
            String localName = propertyName.substring(length + 1 - i2);
            list.add(new PropertyName(namespace, localName));
        }
        this.propertyNames = list.toArray(new PropertyName[list.size()]);
    }

    protected void wirtePropElement(XMLPrinter printer) {
        if (this.propertyNames != null) {
            printer.writeElement("D", "prop", 0);
            for (int i2 = 0; i2 < this.propertyNames.length; ++i2) {
                String namespace = this.propertyNames[i2].getNamespaceURI();
                String localname = this.propertyNames[i2].getLocalName();
                if ("DAV:".equals(namespace)) {
                    printer.writeElement("D", localname, 2);
                    continue;
                }
                printer.writeElement("ZZ", namespace, localname, 2);
            }
            printer.writeElement("D", "prop", 1);
        }
    }
}

